/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.Zone;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Vector3D;
import open.batoru.game.animations.tracker.TrackableAnimation;

public class AnimationCardMoveZoneDrop
extends TrackableAnimation {
    private final Card3D card3D;
    private Zone zoneStart;
    private final Zone zoneEnd;
    private double startZ;
    private static final int DURATION = 500;
    private static final double DROP_HEIGHT = 160.0;

    public AnimationCardMoveZoneDrop(Card3D card3D, Zone zoneEnd) {
        this(card3D, null, zoneEnd);
    }

    public AnimationCardMoveZoneDrop(Card3D card3D, Zone zoneStart, Zone zoneEnd) {
        this.setCycleDuration(500.0);
        this.setInterpolator(Interpolator.EASE_OUT);
        this.card3D = card3D;
        this.zoneStart = zoneStart;
        this.zoneEnd = zoneEnd;
        this.setOnAnimationFinished(this::onAnimationFinished);
    }

    @Override
    public void play() {
        if (this.zoneStart == null) {
            this.zoneStart = this.card3D.getOwnerZone();
        }
        this.zoneStart.removeCardFromZoneList(this.card3D);
        this.zoneStart.updateZone(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_REMOVED);
        Vector3D originEnd = this.zoneEnd.getNextCardOrigin();
        this.startZ = originEnd.getZ();
        this.card3D.setTranslate(originEnd);
        this.card3D.setTransZ(this.startZ - 160.0);
        this.card3D.setRotate(this.zoneEnd.getNextCardRotation());
        this.zoneEnd.prepareNextModifiedIndex(this.zoneEnd.getTotalCards());
        this.card3D.showBack();
        this.card3D.showFace();
        this.zoneStart.prepareRearrangeAnimation(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_REMOVED, Zone.ZonePosition.TOP);
        this.zoneEnd.prepareRearrangeAnimation(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_ADDED, Zone.ZonePosition.TOP);
        if (!GameConst.CardLocation.isSIGNI(this.zoneStart.getZoneLocation()) || !GameConst.CardLocation.isSIGNI(this.zoneEnd.getZoneLocation())) {
            this.card3D.getCardMeshFace().clearTextureLayers();
            this.card3D.getCardMeshBack().clearTextureLayers();
        }
        super.play();
    }

    protected void interpolate(double frac) {
        this.zoneStart.interpolateRearrangeAnimation(frac);
        this.zoneEnd.interpolateRearrangeAnimation(frac);
        this.card3D.setTransZ(this.startZ - 160.0 * (1.0 - frac));
    }

    private void onAnimationFinished() {
        this.card3D.getCardIndex().setLocation(this.zoneEnd.getZoneLocation());
        this.card3D.getCardIndex().resetOverrideLocation();
        if (!(this.card3D.getCardIndex().getIndexedInstance() == null || GameConst.CardLocation.isSIGNI(this.zoneStart.getZoneLocation()) && GameConst.CardLocation.isSIGNI(this.zoneEnd.getZoneLocation()))) {
            this.card3D.getCardIndex().getIndexedInstance().resetStats();
        }
        this.zoneStart.setOnRearrangeAnimationInterpolate(null);
        this.zoneEnd.setOnRearrangeAnimationInterpolate(null);
        this.zoneEnd.addCardToZoneList(this.card3D, Zone.ZonePosition.TOP);
        this.zoneEnd.updateZone(Zone.OnRearrangeAnimationInterpolateHandler.RearrangeType.CARD_ADDED);
    }
}

