/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import java.util.List;
import javafx.animation.Interpolator;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.actions.ActionEnerPay;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Card3DSubstitute;
import open.batoru.game.animations.tracker.TrackableAnimation;

public class AnimationCardPayEner
extends TrackableAnimation {
    private final List<ActionEnerPay.PaidEnerData> paidEnerData;
    private final List<Card3DSubstitute> listEnerSubstitutes;
    private double startX;
    private static final int DURATION = 500;
    private static final int DISTANCE = 1300;

    public AnimationCardPayEner(List<ActionEnerPay.PaidEnerData> paidEnerData, List<Card3DSubstitute> listEnerSubstitutes) {
        this.setCycleDuration(500.0);
        this.setInterpolator(Interpolator.LINEAR);
        this.paidEnerData = paidEnerData;
        this.listEnerSubstitutes = listEnerSubstitutes;
    }

    @Override
    public void play() {
        this.paidEnerData.stream().filter(enerData -> enerData.cardIndexSnapshot().getLocation() == GameConst.CardLocation.ENER).findAny().ifPresent(enerData -> {
            this.startX = enerData.cardIndexSnapshot().getSourceCardIndex().getSourceCard3D().getTransX();
        });
        super.play();
    }

    protected void interpolate(double frac) {
        for (ActionEnerPay.PaidEnerData paidEnerData : this.paidEnerData) {
            if (paidEnerData.cardIndexSnapshot().getLocation() != GameConst.CardLocation.ENER) continue;
            paidEnerData.cardIndexSnapshot().getSourceCardIndex().getSourceCard3D().setTransX(this.startX - 1300.0 * frac);
        }
        if (this.listEnerSubstitutes != null) {
            for (Card3D card3D : this.listEnerSubstitutes) {
                card3D.setTransX(-1300.0 * frac);
            }
        }
    }
}

