/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import open.batoru.UtilRandom;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.FieldData;
import open.batoru.game.FieldZoneCrossIndicator;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game._3d.Card3D;
import open.batoru.game.animations.tracker.TrackableAnimation;

public class AnimationCardRotate
extends TrackableAnimation {
    private final Card3D card3D;
    private final double startZ;
    private final double diffZ;
    private static final int DURATION = 500;

    public AnimationCardRotate(Card3D card3D, boolean isUpped) {
        this.setCycleDuration(500.0);
        this.setInterpolator(Interpolator.EASE_BOTH);
        this.card3D = card3D;
        CardIndex cardIndex = card3D.getCardIndex();
        this.startZ = card3D.getRotateZ();
        boolean isCrossedLeft = cardIndex.getIndexedInstance().isState(131072);
        boolean isCrossedRight = cardIndex.getIndexedInstance().isState(262144);
        if (isUpped) {
            ZoneSIGNI zoneSIGNIOther;
            FieldZoneCrossIndicator crossIndicator;
            this.diffZ = -this.startZ;
            if (isCrossedLeft && (crossIndicator = (zoneSIGNIOther = (ZoneSIGNI)FieldData.getZoneByLocation(cardIndex.getIndexedInstance().getCurrentOwner(), GameConst.CardLocation.getLeftSIGNILocation(cardIndex.getLocation()))).getZoneCrossIndicator(FieldZoneCrossIndicator.CrossPosition.RIGHT)).getState() == FieldZoneCrossIndicator.CrossState.HEAVEN) {
                crossIndicator.setState(FieldZoneCrossIndicator.CrossState.DOWNED);
            }
            if (isCrossedRight && (crossIndicator = (zoneSIGNIOther = (ZoneSIGNI)FieldData.getZoneByLocation(cardIndex.getIndexedInstance().getCurrentOwner(), GameConst.CardLocation.getRightSIGNILocation(cardIndex.getLocation()))).getZoneCrossIndicator(FieldZoneCrossIndicator.CrossPosition.LEFT)).getState() == FieldZoneCrossIndicator.CrossState.HEAVEN) {
                crossIndicator.setState(FieldZoneCrossIndicator.CrossState.DOWNED);
            }
        } else {
            int angle = 90;
            if (isCrossedLeft && isCrossedRight) {
                ZoneSIGNI zoneSIGNILeft = (ZoneSIGNI)FieldData.getZoneByLocation(cardIndex.getIndexedInstance().getCurrentOwner(), GameConst.CardLocation.getLeftSIGNILocation(cardIndex.getLocation()));
                FieldZoneCrossIndicator.CrossState crossStateLeft = zoneSIGNILeft.getZoneCrossIndicator(FieldZoneCrossIndicator.CrossPosition.RIGHT).getState();
                ZoneSIGNI zoneSIGNIRight = (ZoneSIGNI)FieldData.getZoneByLocation(cardIndex.getIndexedInstance().getCurrentOwner(), GameConst.CardLocation.getRightSIGNILocation(cardIndex.getLocation()));
                FieldZoneCrossIndicator.CrossState crossStateRight = zoneSIGNIRight.getZoneCrossIndicator(FieldZoneCrossIndicator.CrossPosition.LEFT).getState();
                if (crossStateLeft == FieldZoneCrossIndicator.CrossState.DOWNED && crossStateRight == FieldZoneCrossIndicator.CrossState.DOWNED) {
                    angle = UtilRandom.get_z(10) < 5 ? 90 : -90;
                } else if (crossStateLeft == FieldZoneCrossIndicator.CrossState.DOWNED) {
                    angle = -90;
                }
            } else if (isCrossedLeft) {
                angle = -90;
            }
            this.diffZ = (double)angle - this.startZ;
        }
    }

    public AnimationCardRotate(Card3D card3D, int angle) {
        this.setCycleDuration(500.0);
        this.setInterpolator(Interpolator.EASE_BOTH);
        this.card3D = card3D;
        this.startZ = card3D.getRotateZ();
        this.diffZ = (double)angle - this.startZ;
    }

    protected void interpolate(double frac) {
        this.card3D.setRotateZ(this.startZ + this.diffZ * frac);
    }
}

