/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.util.Duration;
import open.batoru.game._3d.Card3D;
import open.batoru.game._3d.Group3D;

public class AnimationHandHover
extends Transition {
    private final double startZ;
    private final double startY;
    private final double diffZ;
    private final double diffY;
    private final Card3D card3D;
    private static final int DURATION = 100;
    private static final int DISTANCE = 40;

    public AnimationHandHover(Group3D nodeHand, Card3D card3D, boolean forward) {
        this.setCycleDuration(Duration.millis((double)100.0));
        this.setInterpolator(Interpolator.EASE_OUT);
        int moveDistance = forward ? 40 : 0;
        this.card3D = card3D;
        this.startZ = card3D.getTransZ();
        this.startY = card3D.getTransY();
        double angle = Math.toRadians(card3D.getRotateX());
        double endZ = nodeHand.getTransZ() - (double)moveDistance * Math.sin(angle);
        double endY = nodeHand.getTransY() - (double)moveDistance * Math.cos(angle);
        this.diffZ = endZ - this.startZ;
        this.diffY = endY - this.startY;
    }

    protected void interpolate(double frac) {
        this.card3D.setTransZ(this.startZ + this.diffZ * frac);
        this.card3D.setTransY(this.startY + this.diffY * frac);
    }
}

