/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import javafx.scene.paint.Color;
import javafx.scene.paint.CycleMethod;
import javafx.scene.paint.Paint;
import javafx.scene.paint.RadialGradient;
import javafx.scene.paint.Stop;
import javafx.scene.shape.Circle;
import open.batoru.game.FieldZoneCrossIndicator;
import open.batoru.game.PlayerField;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game._3d.Group3D;
import open.batoru.game.animations.tracker.TrackableAnimation;
import open.batoru.ui.UI;

public class AnimationHeaven
extends TrackableAnimation {
    private final FieldZoneCrossIndicator crossIndicator;
    private final Group3D node = new Group3D();
    private Circle ripple;
    private final PlayerField field;

    public AnimationHeaven(ZoneSIGNI zoneSIGNI, FieldZoneCrossIndicator.CrossPosition position) {
        this.setInterpolator(Interpolator.EASE_OUT);
        this.setStaticCycleDuration(400.0);
        this.crossIndicator = zoneSIGNI.getZoneCrossIndicator(position);
        this.field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByZoneFlip(zoneSIGNI.isFlipped());
        this.setOnAnimationFinished(() -> this.field.getChildren().remove((Object)this.node));
    }

    @Override
    public void play() {
        this.ripple = new Circle(0.0);
        this.ripple.setFill((Paint)new RadialGradient(0.0, 0.0, 0.5, 0.5, 0.5, true, CycleMethod.NO_CYCLE, new Stop[]{new Stop(0.5, Color.TRANSPARENT), new Stop(1.0, Color.GOLD)}));
        this.node.getChildren().add((Object)this.ripple);
        this.node.setTranslate(this.crossIndicator.getTransX() + (double)(this.crossIndicator.getPosition() == FieldZoneCrossIndicator.CrossPosition.LEFT ? -30 : 30), this.crossIndicator.getTransY(), this.crossIndicator.getTransZ() - 2.0);
        this.field.getChildren().add((Object)this.node);
        super.play();
    }

    protected void interpolate(double frac) {
        this.ripple.setRadius(300.0 * frac);
        this.ripple.setOpacity(1.0 - frac);
    }
}

