/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableAnimation;
import open.batoru.game.animations.tracker.TrackableSequentialTransition;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;
import open.batoru.ui.UIConst;

public class AnimationPhaseAdvance
extends TrackableSequentialTransition {
    private final AnimationTracker tracker;
    private final GameConst.GamePhase phase;
    private final Group group = new Group();
    private double width;

    public AnimationPhaseAdvance(AnimationTracker tracker, GameConst.GamePhase phase) {
        super(tracker);
        this.tracker = tracker;
        this.phase = phase;
        this.group.setMouseTransparent(true);
    }

    @Override
    public void play() {
        this.width = UI.getTabGame().getFieldSceneOverlay().getRootNode().getWidth();
        StackPane node = new StackPane();
        node.setBackground(UIConst.Style.BACKGROUND_BLACK);
        node.setBorder(UIConst.Style.BORDER_KHAKI);
        node.setMinSize(500.0, 40.0);
        node.setMaxSize(node.getMinWidth(), node.getMinHeight());
        node.setPadding(new Insets(10.0));
        Text text = new Text(this.phase.getLongLabel());
        text.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)24.0));
        text.setFill((Paint)Color.KHAKI);
        node.getChildren().add((Object)text);
        this.group.getChildren().add((Object)node);
        this.group.setTranslateX(UI.getTabGame().getFieldSceneOverlay().getRootNode().getWidth() / 2.0 + 250.0);
        UI.getTabGame().getFieldSceneOverlay().getRootNode().getChildren().addFirst((Object)this.group);
        StackPane.setAlignment((Node)node, (Pos)Pos.CENTER_RIGHT);
        AnimationSlide aniSlide1 = new AnimationSlide();
        AnimationSlide aniSlide2 = new AnimationSlide();
        aniSlide2.setDelay(250.0);
        aniSlide1.setAnimationTracker(this.tracker);
        aniSlide2.setAnimationTracker(this.tracker);
        this.getAnimationList().add(aniSlide1);
        this.getAnimationList().add(aniSlide2);
        aniSlide2.setOnAnimationFinished(() -> UI.getTabGame().getFieldSceneOverlay().getRootNode().getChildren().remove((Object)this.group));
        super.play();
    }

    private class AnimationSlide
    extends TrackableAnimation {
        private double startX;

        public AnimationSlide() {
            this.setStaticCycleDuration(125.0);
            this.setInterpolator(Interpolator.LINEAR);
        }

        @Override
        public void play() {
            this.startX = AnimationPhaseAdvance.this.group.getTranslateX();
            super.play();
        }

        protected void interpolate(double frac) {
            AnimationPhaseAdvance.this.group.setTranslateX(this.startX - (AnimationPhaseAdvance.this.width / 2.0 + 250.0) * frac);
        }
    }
}

