/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import open.batoru.game.FieldZoneNumbers;
import open.batoru.game.animations.tracker.TrackableAnimation;

public class AnimationPowerChange
extends TrackableAnimation {
    private final FieldZoneNumbers zoneNumbers;
    private final double powerBase;
    private final double powerOld;
    private final double powerNew;
    public static final int DURATION = 200;

    public AnimationPowerChange(FieldZoneNumbers zoneNumbers, double powerBase, double powerOld, double powerNew) {
        this.setStaticCycleDuration(200.0);
        this.setInterpolator(Interpolator.LINEAR);
        this.zoneNumbers = zoneNumbers;
        this.powerBase = powerBase;
        this.powerOld = powerOld;
        this.powerNew = powerNew;
    }

    protected void interpolate(double frac) {
        double powerStep = this.powerOld + (this.powerNew - this.powerOld) * frac;
        this.zoneNumbers.setValue(powerStep);
        this.zoneNumbers.setColorByValue(this.powerBase, powerStep);
    }
}

