/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import javafx.util.Duration;
import open.batoru.game.FieldZoneSpinner;
import open.batoru.game._3d.Group3D;
import open.batoru.game.animations.AnimationSpinnerRotate;

public class AnimationSpinnerRotateCustom
extends AnimationSpinnerRotate {
    private FieldZoneSpinner spinner;
    private double[] startAngle;
    private final int directionMulti;
    private final int radius;
    private final int offsetZ;

    public AnimationSpinnerRotateCustom(int cycleDuration, int radius, int offsetZ) {
        this(cycleDuration, radius, offsetZ, SpinDirection.COUNTER_CLOCKWISE);
    }

    public AnimationSpinnerRotateCustom(int cycleDuration, int radius, int offsetZ, SpinDirection spinDirection) {
        this.setCycleDuration(Duration.millis((double)cycleDuration));
        this.setCycleCount(-1);
        this.setInterpolator(Interpolator.LINEAR);
        this.radius = radius;
        this.offsetZ = offsetZ;
        this.directionMulti = spinDirection == SpinDirection.COUNTER_CLOCKWISE ? 1 : -1;
    }

    @Override
    public void setSpinner(FieldZoneSpinner spinner) {
        this.spinner = spinner;
        spinner.setTranslateZ(this.offsetZ);
        this.startAngle = new double[spinner.getListSpinNodes().size()];
        for (int i = 0; i < spinner.getListSpinNodes().size(); ++i) {
            this.startAngle[i] = (double)i * (360.0 / (double)spinner.getListSpinNodes().size());
        }
    }

    @Override
    protected void interpolate(double frac) {
        for (int i = 0; i < this.spinner.getListSpinNodes().size(); ++i) {
            Group3D nodeSpin = this.spinner.getListSpinNodes().get(i);
            double angle = (this.startAngle[i] + (double)this.directionMulti * (360.0 * frac)) % 360.0;
            double sin = Math.sin(Math.toRadians(angle));
            double cos = Math.cos(Math.toRadians(angle));
            nodeSpin.setTransX(sin * (double)this.radius);
            nodeSpin.setTransY(cos * (double)this.radius);
        }
    }

    public static enum SpinDirection {
        CLOCKWISE,
        COUNTER_CLOCKWISE;

    }
}

