/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.scene.control.Button;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.util.Duration;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.ui.UIConst;

public class AnimationUITextFlash
extends Transition {
    private final Button button;
    private final Text text;
    private boolean toggle;
    public static final int DURATION = 250;

    public AnimationUITextFlash(Button button, Text text) {
        this.setCycleDuration(Duration.millis((double)250.0));
        this.setCycleCount(-1);
        this.setInterpolator(Interpolator.DISCRETE);
        this.button = button;
        this.text = text;
    }

    protected void interpolate(double frac) {
        if (frac == 1.0) {
            boolean bl = this.toggle = !this.toggle;
        }
        if (this.button != null) {
            this.button.setBorder(this.toggle ? UIConst.Style.BORDER_LIGHTGREEN : UIConst.Style.BORDER_KHAKI);
            this.button.setTextFill((Paint)(this.toggle ? Color.LIGHTGREEN : Color.KHAKI));
        }
        if (this.text != null) {
            this.text.setFill((Paint)(this.toggle ? Color.LIGHTGREEN : Color.KHAKI));
        }
    }

    public void play() {
        AnimationTracker.addRunningAnimation(this);
        super.play();
    }

    public void stop() {
        AnimationTracker.removeRunningAnimation(this);
        super.stop();
        if (this.button != null) {
            this.button.setBorder(UIConst.Style.BORDER_KHAKI);
            this.button.setTextFill((Paint)Color.KHAKI);
        }
        if (this.text != null) {
            this.text.setFill((Paint)Color.KHAKI);
        }
    }
}

