/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.scene.text.Text;
import javafx.util.Duration;

public class AnimationUITextThinking
extends Transition {
    private final Text text;
    private final int dotCount;
    private final String stringDots;
    private String originalTextString;
    private static final int DURATION = 1000;

    public AnimationUITextThinking(Text text, int dotCount) {
        this.setCycleDuration(Duration.millis((double)1000.0));
        this.setCycleCount(-1);
        this.setInterpolator(Interpolator.LINEAR);
        this.text = text;
        this.dotCount = dotCount + 1;
        this.stringDots = ".".repeat(Math.max(0, this.dotCount));
    }

    public void play() {
        this.originalTextString = this.text.getText();
        super.play();
    }

    protected void interpolate(double frac) {
        this.text.setText(this.originalTextString + this.stringDots.substring(this.dotCount - (int)((double)this.dotCount * frac)));
    }

    public void stop() {
        super.stop();
        this.text.setText(this.originalTextString);
    }
}

