/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import java.util.List;
import javafx.animation.Interpolator;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.ZoneSIGNI;
import open.batoru.game._3d.Card3D;
import open.batoru.game.animations.tracker.TrackableAnimation;

public class AnimationZoneExchange
extends TrackableAnimation {
    private final ZoneSIGNI zone1;
    private final ZoneSIGNI zone2;
    private final int offset1;
    private final int offset2;
    private double zone1CardOriginStartX;
    private double zone1CardOriginDiffX;
    private double zone2CardOriginStartX;
    private double zone2CardOriginDiffX;
    private static final int DURATION = 500;

    public AnimationZoneExchange(ZoneSIGNI zone1, ZoneSIGNI zone2) {
        this.setCycleDuration(500.0);
        this.setInterpolator(Interpolator.LINEAR);
        List<Card3D> listCards1 = zone1.getZoneCardList();
        int skipped1 = 0;
        for (int i = 0; i < listCards1.size(); ++i) {
            if (listCards1.get(i).getCardIndex().getUnderType().getUnderCategory() != GameConst.CardUnderCategory.ZONE) continue;
            skipped1 = i + 1;
            break;
        }
        List<Card3D> listCards2 = zone2.getZoneCardList();
        int skipped2 = 0;
        for (int i = 0; i < listCards2.size(); ++i) {
            if (listCards2.get(i).getCardIndex().getUnderType().getUnderCategory() != GameConst.CardUnderCategory.ZONE) continue;
            skipped2 = i + 1;
            break;
        }
        if (zone1.getTotalCards() - skipped1 < zone2.getTotalCards() - skipped2) {
            this.zone1 = zone2;
            this.offset1 = skipped2;
            this.zone2 = zone1;
            this.offset2 = skipped1;
        } else {
            this.zone1 = zone1;
            this.offset1 = skipped1;
            this.zone2 = zone2;
            this.offset2 = skipped2;
        }
        this.setOnAnimationFinished(() -> ZoneSIGNI.transferCardListData(zone1, zone2));
    }

    @Override
    public void play() {
        if (this.zone1 == this.zone2) {
            return;
        }
        this.zone1CardOriginStartX = this.zone1.getNextCardOrigin().getX();
        this.zone1CardOriginDiffX = this.zone2.getNextCardOrigin().getX() - this.zone1CardOriginStartX;
        if (this.zone2.getTopCard() != null) {
            this.zone2CardOriginStartX = this.zone2.getNextCardOrigin().getX();
            this.zone2CardOriginDiffX = this.zone1.getNextCardOrigin().getX() - this.zone2CardOriginStartX;
        }
        super.play();
    }

    protected void interpolate(double frac) {
        Card3D card3D;
        int i;
        for (i = this.offset1; i < this.zone1.getTotalCards(); ++i) {
            card3D = this.zone1.getZoneCardList().get(i);
            card3D.setTransX(this.zone1CardOriginStartX + this.zone1CardOriginDiffX * frac);
            card3D.setTransZ((double)i * -4.0 - (double)(this.offset2 - this.offset1) * 4.0 * frac);
        }
        for (i = this.offset2; i < this.zone2.getTotalCards(); ++i) {
            card3D = this.zone2.getZoneCardList().get(i);
            card3D.setTransX(this.zone2CardOriginStartX + this.zone2CardOriginDiffX * frac);
            card3D.setTransZ((double)i * -4.0 - (double)(this.offset1 - this.offset2) * 4.0 * frac);
        }
    }
}

