/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations;

import java.util.ArrayList;
import java.util.List;
import javafx.animation.Interpolator;
import javafx.animation.Transition;
import javafx.geometry.Bounds;
import javafx.scene.paint.Color;
import javafx.scene.shape.CullFace;
import javafx.util.Duration;
import open.batoru.ImageCache;
import open.batoru.game.Zone;
import open.batoru.game._3d.Plane;
import open.batoru.game._3d.Vector3D;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.ui.UI;

public class AnimationZoneTracer
extends Transition {
    private static final int DURATION = 7500;
    private static final double ARC_HEIGHT = 500.0;
    private final Color color;
    private final Vector3D coords1;
    private final Vector3D coords2;
    private final int numIcons;
    private final double midZ;
    private final double angleZ;
    private final double angleArc;
    private final List<TracerIcon> icons = new ArrayList<TracerIcon>();

    public AnimationZoneTracer(Zone zone1, Zone zone2, Color color, String iconName) {
        this.setCycleDuration(Duration.millis((double)7500.0));
        this.setInterpolator(Interpolator.LINEAR);
        this.setCycleCount(-1);
        this.color = color;
        Bounds b1 = zone1.getNode().localToScene(zone1.getNode().getBoundsInLocal());
        double x = b1.getMaxX() - b1.getWidth() / 2.0;
        double y = b1.getMaxY() - b1.getHeight() / 2.0;
        double z = b1.getMaxZ() - b1.getDepth() / 2.0;
        this.coords1 = new Vector3D(x, y, z);
        Bounds b2 = zone2.getNode().localToScene(zone2.getNode().getBoundsInLocal());
        double x2 = b2.getMaxX() - b2.getWidth() / 2.0;
        double y2 = b2.getMaxY() - b2.getHeight() / 2.0;
        double z2 = b2.getMaxZ() - b2.getDepth() / 2.0;
        this.coords2 = new Vector3D(x2, y2, z2);
        double deltaX = this.coords2.getX() - this.coords1.getX();
        double deltaY = this.coords2.getY() - this.coords1.getY();
        this.angleZ = Math.toDegrees(Math.atan2(deltaY, deltaX));
        this.midZ = Math.max(this.coords1.getZ(), this.coords2.getZ()) - 500.0;
        double distance = Math.sqrt(deltaX * deltaX + deltaY * deltaY);
        this.angleArc = Math.toDegrees(2.0 * Math.acos(1.0 - 500.0 / distance / 4.0));
        this.numIcons = (int)distance / 28;
        for (int i = 0; i < this.numIcons; ++i) {
            TracerIcon icon = new TracerIcon(i, iconName);
            this.icons.add(icon);
        }
    }

    public void interpolate(double frac) {
        for (TracerIcon icon : this.icons) {
            icon.move(frac);
        }
    }

    public void play() {
        UI.getTabGame().getFieldScene().getGameField().getChildren().addAll(this.icons);
        AnimationTracker.addRunningAnimation(this);
        super.play();
    }

    public void stop() {
        AnimationTracker.removeRunningAnimation(this);
        super.stop();
        UI.getTabGame().getFieldScene().getGameField().getChildren().removeAll(this.icons);
        this.icons.clear();
    }

    private class TracerIcon
    extends Plane {
        private static final int WIDTH = 28;
        private static final int HEIGHT = 60;
        private final int id;

        public TracerIcon(int id, String iconName) {
            super(28, 60, ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath(iconName)));
            this.getMaterial().setDiffuseColor(AnimationZoneTracer.this.color);
            this.getRender().setCullFace(CullFace.NONE);
            this.setMouseTransparent(true);
            this.id = id;
            this.setRotateZ(AnimationZoneTracer.this.angleZ);
        }

        public void move(double frac) {
            frac = (frac + (double)this.id / (double)AnimationZoneTracer.this.numIcons) % 1.0;
            double zOffset = 2.0 * (1.0 - frac) * frac * AnimationZoneTracer.this.midZ + frac * frac * AnimationZoneTracer.this.coords2.getZ();
            double angleY = (1.0 - frac) * AnimationZoneTracer.this.angleArc + frac * -AnimationZoneTracer.this.angleArc;
            double xOffset = Math.cos(Math.toRadians(AnimationZoneTracer.this.angleZ)) * (double)AnimationZoneTracer.this.numIcons * 28.0 * frac;
            double yOffset = Math.sin(Math.toRadians(AnimationZoneTracer.this.angleZ)) * (double)AnimationZoneTracer.this.numIcons * 28.0 * frac;
            this.setTranslate(new Vector3D(AnimationZoneTracer.this.coords1, xOffset, yOffset, zOffset));
            this.setRotateY(angleY);
        }
    }
}

