/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.animations.tracker;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import open.batoru.game.animations.tracker.AnimationTracker;
import open.batoru.game.animations.tracker.TrackableAnimation;

public class TrackableSequentialTransition {
    private final List<ParallelStream> parallelStreams;
    private final AnimationTracker tracker;
    private int countFinished;
    private AnimationTracker.TrackableAnimationHandler handlerFinished;

    public TrackableSequentialTransition(AnimationTracker tracker) {
        this(tracker, 1);
    }

    public TrackableSequentialTransition(AnimationTracker tracker, int parallelStreams) {
        this.tracker = tracker;
        this.parallelStreams = new ArrayList<ParallelStream>(parallelStreams);
        for (int i = 0; i < parallelStreams; ++i) {
            this.parallelStreams.add(new ParallelStream(0));
        }
    }

    public List<TrackableAnimation> getAnimationList() {
        return this.getAnimationList(0);
    }

    public List<TrackableAnimation> getAnimationList(int streamId) {
        return streamId >= 0 && streamId < this.parallelStreams.size() ? this.parallelStreams.get(streamId).getAnimations() : null;
    }

    public void setParallelStreamDelay(int streamId, int delaySteps) {
        if (streamId < 0 || streamId >= this.parallelStreams.size()) {
            return;
        }
        this.parallelStreams.get(streamId).setDelay(delaySteps);
    }

    public void play() {
        if (this.parallelStreams.getFirst().getAnimations().isEmpty()) {
            return;
        }
        this.tracker.setOnTrackerFinished(ani -> {
            ++this.countFinished;
            ListIterator<ParallelStream> iterator = this.parallelStreams.listIterator();
            while (iterator.hasNext()) {
                ParallelStream stream = (ParallelStream)iterator.next();
                if (stream.getDelay() == this.countFinished) {
                    stream.getAnimations().getFirst().play();
                    continue;
                }
                if (!stream.getAnimations().contains((Object)ani)) continue;
                if (this.handlerFinished != null) {
                    this.handlerFinished.handle(ani);
                }
                stream.getAnimations().removeFirst();
                if (!stream.getAnimations().isEmpty()) {
                    stream.getAnimations().getFirst().play();
                    continue;
                }
                iterator.remove();
            }
        });
        for (ParallelStream stream : this.parallelStreams) {
            if (stream.getDelay() > 0 || stream.getAnimations().isEmpty()) continue;
            stream.getAnimations().getFirst().play();
        }
    }

    public void setOnTrackerFinished(AnimationTracker.TrackableAnimationHandler handler) {
        this.handlerFinished = handler;
    }

    private static class ParallelStream {
        private final LinkedList<TrackableAnimation> animations = new LinkedList();
        private int delay;

        public ParallelStream(int delay) {
            this.delay = delay;
        }

        public LinkedList<TrackableAnimation> getAnimations() {
            return this.animations;
        }

        public int getDelay() {
            return this.delay;
        }

        public void setDelay(int delaySteps) {
            this.delay = delaySteps;
        }
    }
}

