/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.gfx;

import java.util.HashMap;
import java.util.function.Function;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.ChronoRecordScheduler;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.ConstantAbilityShared;
import open.batoru.ui.FX;

public abstract class GFX {
    protected abstract void onAttached();

    protected abstract void onDetached();

    public final void attach() {
        FX.run(this::onAttached);
    }

    public final void detach() {
        FX.run(this::onDetached);
    }

    public static void attachToChronoRecord(ChronoRecordScheduler.ChronoRecord record, GFX gfx) {
        record.setOnChronoRecordAdded(gfx::attach);
        record.setOnChronoRecordExpired(gfx::detach);
    }

    public static void attachToAbility(Ability ability, GFX gfx) {
        ability.setOnAbilityEnabled(cardIndex -> gfx.onAttached());
        ability.setOnAbilityDisabled(cardIndex -> gfx.onDetached());
    }

    public static void attachToSharedAbility(ConstantAbilityShared abilityShared, Function<CardIndex, GFX> handlerGFX) {
        HashMap mapSharedGFX = new HashMap();
        abilityShared.setOnAbilityEnabled(cardIndex -> {
            GFX gfx = (GFX)handlerGFX.apply(cardIndex);
            gfx.onAttached();
            mapSharedGFX.putIfAbsent(cardIndex, gfx);
        });
        abilityShared.setOnAbilityDisabled(cardIndex -> mapSharedGFX.computeIfPresent(cardIndex, (c, gfx) -> {
            gfx.onDetached();
            return null;
        }));
    }
}

