/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.gfx;

import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import open.batoru.ImageCache;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.game._3d.textures.PostProcessPixelTextureLayer;
import open.batoru.game.gfx.GFX;

public class GFXCardCutout
extends GFX {
    private final CardIndex cardIndex;
    private final PostProcessPixelTextureLayer layer;

    public GFXCardCutout(CardIndex cardIndex, String textureName) {
        this.cardIndex = cardIndex;
        Image texture = ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("zones/overlay/card/" + textureName));
        this.layer = new PostProcessPixelTextureLayer("GFX", (x, y, color) -> {
            Color newColor = texture.getPixelReader().getColor(x, y);
            return newColor.getOpacity() == 0.0 ? color : Color.hsb((double)color.getHue(), (double)color.getSaturation(), (double)color.getBrightness(), (double)0.01);
        });
    }

    @Override
    protected void onAttached() {
        this.cardIndex.getSourceCard3D().getCardMeshFace().addTextureLayer(this.layer);
    }

    @Override
    protected void onDetached() {
        this.cardIndex.getSourceCard3D().getCardMeshFace().removeTextureLayer(this.layer);
    }
}

