/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.gfx;

import open.batoru.ImageCache;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.game._3d.textures.ImageTextureLayer;
import open.batoru.game._3d.textures.TextureLayer;
import open.batoru.game._3d.textures.UtilTextureLayer;
import open.batoru.game.gfx.GFX;
import open.batoru.game.gfx.GFXTextureCardCanvas;

public class GFXCardTextureLayer
extends GFX {
    private final CardIndex cardIndex;
    private final TextureLayer<?> layer;

    public GFXCardTextureLayer(CardIndex cardIndex, String textureName) {
        this.cardIndex = cardIndex;
        this.layer = new ImageTextureLayer("GFX", ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("zones/overlay/card/" + textureName)));
    }

    public GFXCardTextureLayer(CardIndex cardIndex, GFXTextureCardCanvas textureCanvas) {
        this.cardIndex = cardIndex;
        this.layer = new ImageTextureLayer("GFX", textureCanvas.getImageView());
    }

    public GFXCardTextureLayer(CardIndex cardIndex, UtilTextureLayer.TextureType textureType) {
        this.cardIndex = cardIndex;
        this.layer = UtilTextureLayer.getTexture(textureType);
    }

    @Override
    protected void onAttached() {
        this.cardIndex.getSourceCard3D().getCardMeshFace().addTextureLayer(this.layer);
    }

    @Override
    protected void onDetached() {
        this.cardIndex.getSourceCard3D().getCardMeshFace().removeTextureLayer(this.layer);
    }
}

