/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.gfx;

import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import open.batoru.ImageCache;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.FieldData;
import open.batoru.game.PlayerField;
import open.batoru.game.Zone;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.Plane;
import open.batoru.game.gfx.GFX;
import open.batoru.ui.UI;

@Deprecated
public class GFXFieldBackground
extends GFX {
    private final Game.GamePlayerRole rolePlayer;
    private final Group3D node = new Group3D();
    private boolean withCenterOffset;

    public GFXFieldBackground(Game.GamePlayerRole rolePlayer, String textureName, int width, int height, int originX, int originY) {
        this(rolePlayer, textureName, width, height, originX, originY, new int[]{255, 255, 255});
    }

    public GFXFieldBackground(Game.GamePlayerRole rolePlayer, String textureName, int width, int height, int originX, int originY, int[] colorRGB) {
        this.rolePlayer = rolePlayer;
        Image texture = ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("zones/" + textureName));
        Plane plane = new Plane(width, height, texture);
        if (colorRGB != null) {
            plane.getMaterial().setDiffuseColor(Color.rgb((int)colorRGB[0], (int)colorRGB[1], (int)colorRGB[2]));
        }
        this.node.getChildren().add((Object)plane);
        this.node.setTranslateX(originX);
        this.node.setTranslateY(originY);
        this.node.setTransZ(-2.0);
    }

    public GFXFieldBackground withCenterOffset() {
        this.withCenterOffset = true;
        return this;
    }

    public GFXFieldBackground(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, String textureName) {
        Zone zone = FieldData.getZoneByLocation(rolePlayer, location);
        if (zone == null) {
            throw new IllegalArgumentException();
        }
        this.rolePlayer = rolePlayer;
        Image texture = ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("zones/" + textureName));
        Plane plane = new Plane((int)texture.getWidth(), (int)texture.getHeight(), texture);
        this.node.getChildren().add((Object)plane);
        this.node.setTranslate(zone.getNode());
        this.node.setTransZ(-2.0);
    }

    @Override
    protected void onAttached() {
        PlayerField field = UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer);
        field.getFieldBackground().getChildren().add((Object)this.node);
        if (this.withCenterOffset && !field.getLRIGAssistZoneLeft().getNode().isVisible()) {
            this.node.setTransX(this.node.getTransX() - field.getCenterOffset());
        }
    }

    @Override
    protected void onDetached() {
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getFieldBackground().getChildren().remove((Object)this.node);
    }
}

