/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.gfx;

import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.function.Function;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.Card;
import open.batoru.data.DataTable;
import open.batoru.game.gfx.GFX;
import open.batoru.ui.UI;

public class GFXTrackedCardDecorator
extends GFX {
    private final Game.GamePlayerRole rolePlayer;
    private final GFXTracker gfxTracker;

    public GFXTrackedCardDecorator(Game.GamePlayerRole rolePlayer, TargetFilter filter, Function<CardIndex, GFX> handlerSample) {
        this.rolePlayer = rolePlayer;
        filter.setTargetRole(rolePlayer);
        filter = filter.ownedBy(rolePlayer);
        this.gfxTracker = new GFXTracker(filter, handlerSample);
    }

    @Override
    protected void onAttached() {
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getVisualStateCoordinator().addGFXTracker(this.gfxTracker);
    }

    @Override
    protected void onDetached() {
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getVisualStateCoordinator().removeGFXTracker(this.gfxTracker);
    }

    public static class GFXTracker {
        private final TargetFilter filter;
        private final Function<CardIndex, GFX> handlerSample;
        private final Map<CardIndex, TrackedCardData> map = new WeakHashMap<CardIndex, TrackedCardData>();

        public GFXTracker(TargetFilter filter, Function<CardIndex, GFX> handlerSample) {
            this.filter = filter;
            this.handlerSample = handlerSample;
        }

        public void update() {
            CardIndex cardIndex;
            DataTable<CardIndex> data = this.filter.getExportedData(true);
            for (int i = 0; i < data.size(); ++i) {
                cardIndex = (CardIndex)data.get(i);
                TrackedCardData trackedCardData = this.map.computeIfAbsent(cardIndex, k -> {
                    GFX gfx = this.handlerSample.apply(cardIndex);
                    gfx.attach();
                    return new TrackedCardData(gfx, cardIndex.getLocation(), cardIndex.getIndexedInstance());
                });
                if (trackedCardData.lastLocation == cardIndex.getLocation() && trackedCardData.lastIndexedInstance == cardIndex.getIndexedInstance()) continue;
                trackedCardData.gfx.detach();
                trackedCardData.gfx.attach();
                trackedCardData.lastLocation = cardIndex.getLocation();
                trackedCardData.lastIndexedInstance = cardIndex.getIndexedInstance();
            }
            Iterator<CardIndex> it = this.map.keySet().iterator();
            while (it.hasNext()) {
                cardIndex = it.next();
                if (data.contains(cardIndex)) continue;
                this.map.get((Object)cardIndex).gfx.detach();
                it.remove();
            }
        }

        public void clearAll() {
            this.map.values().forEach(trackedCardData -> trackedCardData.gfx.detach());
            this.map.clear();
        }

        private static class TrackedCardData {
            private final GFX gfx;
            private GameConst.CardLocation lastLocation;
            private Card.IndexedInstance lastIndexedInstance;

            public TrackedCardData(GFX gfx, GameConst.CardLocation location, Card.IndexedInstance indexedInstance) {
                this.gfx = gfx;
                this.lastLocation = location;
                this.lastIndexedInstance = indexedInstance;
            }
        }
    }
}

