/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.gfx;

import javafx.scene.paint.Color;
import open.batoru.ImageCache;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.FieldData;
import open.batoru.game.Zone;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.Plane;
import open.batoru.game.gfx.GFX;
import open.batoru.ui.UI;

public class GFXZoneBackground
extends GFX {
    private final Game.GamePlayerRole rolePlayer;
    private final Group3D node = new Group3D();

    public GFXZoneBackground(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, String textureName, double scale, int[] colorsRGB) {
        this(rolePlayer, location, textureName, scale, scale, colorsRGB);
    }

    public GFXZoneBackground(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, String textureName, double scaleX, double scaleY, int[] colorsRGB) {
        Zone zone = FieldData.getZoneByLocation(rolePlayer, location);
        if (zone == null) {
            throw new IllegalArgumentException();
        }
        this.rolePlayer = rolePlayer;
        int dimension = Math.max(zone.getWidth(), zone.getHeight());
        Plane plane = new Plane((int)((double)dimension * scaleX), (int)((double)dimension * scaleY), ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("zones/" + textureName)));
        plane.getMaterial().setDiffuseColor(Color.rgb((int)colorsRGB[0], (int)colorsRGB[1], (int)colorsRGB[2]));
        this.node.getChildren().add((Object)plane);
        this.node.setTranslate(zone.getNode());
        this.node.setTransZ(zone.getNode().getTransZ() + 2.0);
    }

    @Override
    protected void onAttached() {
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getChildren().addFirst((Object)this.node);
    }

    @Override
    protected void onDetached() {
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getChildren().remove((Object)this.node);
    }
}

