/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.gfx;

import javafx.scene.image.Image;
import open.batoru.ImageCache;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.FieldData;
import open.batoru.game.Zone;
import open.batoru.game._3d.Plane;
import open.batoru.game._3d.textures.UtilTexture;
import open.batoru.game.gfx.GFX;

public class GFXZoneCutout
extends GFX {
    private final Zone zone;
    private final Plane node;
    private Zone.OnCardMovedHandler handler;

    public GFXZoneCutout(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, String textureName) {
        Zone zone = FieldData.getZoneByLocation(rolePlayer, location);
        if (zone == null) {
            throw new IllegalArgumentException();
        }
        this.zone = zone;
        Image texture = ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("zones/overlay/card/" + textureName));
        this.node = new Plane((int)texture.getWidth(), (int)texture.getHeight(), (Image)UtilTexture.cutout(texture));
        this.node.setMouseTransparent(true);
    }

    @Override
    protected void onAttached() {
        this.zone.getNode().getChildren().add((Object)this.node);
        this.updateNode();
        this.handler = (card3D, rearrangeType) -> this.updateNode();
        this.zone.setOnCardMoved(this.handler);
    }

    private void updateNode() {
        if (this.zone.getTotalCards() != 0) {
            this.node.setVisible(true);
            this.node.setTransZ(this.zone.getTopCard().getTransZ() - 5.0);
        } else {
            this.node.setVisible(false);
        }
    }

    @Override
    protected void onDetached() {
        this.zone.getNode().getChildren().remove((Object)this.node);
        this.zone.removeCardMovedHandler(this.handler);
    }
}

