/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.gfx;

import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import open.batoru.ImageCache;
import open.batoru.UtilRandom;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.FieldData;
import open.batoru.game.Zone;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.Plane;
import open.batoru.game.gfx.GFX;
import open.batoru.ui.UI;

public class GFXZoneOutlineDetail
extends GFX {
    private final Game.GamePlayerRole rolePlayer;
    private final Group3D node = new Group3D();
    private final Image texture;

    public GFXZoneOutlineDetail(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, String textureName) {
        this(rolePlayer, location, textureName, BorderType.OUTER);
    }

    public GFXZoneOutlineDetail(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, String textureName, BorderType borderType) {
        this(rolePlayer, location, textureName, 0, borderType, BorderPosition.TOP, BorderPosition.RIGHT, BorderPosition.LEFT, BorderPosition.BOTTOM);
    }

    public GFXZoneOutlineDetail(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, String textureName, int offsetZ, BorderType borderType, BorderPosition ... borderPositions) {
        Zone zone = FieldData.getZoneByLocation(rolePlayer, location);
        if (zone == null) {
            throw new IllegalArgumentException();
        }
        this.rolePlayer = rolePlayer;
        this.texture = ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("zones/overlay/outline/" + textureName));
        for (BorderPosition pos : borderPositions) {
            this.node.getChildren().add((Object)this.createDetail(zone, pos, borderType));
        }
        this.node.setTransZ(offsetZ);
    }

    private Plane createDetail(Zone zone, BorderPosition pos, BorderType borderType) {
        double paddingHeight;
        double paddingWidth;
        Plane plane = new Plane((int)this.texture.getWidth(), (int)this.texture.getHeight(), this.texture);
        if (borderType == BorderType.OUTER) {
            paddingWidth = this.texture.getWidth() / 2.0;
            paddingHeight = this.texture.getHeight() / 2.0;
        } else {
            paddingWidth = -this.texture.getWidth() / 2.0;
            paddingHeight = -this.texture.getHeight() / 2.0;
        }
        switch (pos.ordinal()) {
            case 0: {
                plane.setTransX(zone.getNode().getTransX() + UtilRandom.get((double)(-zone.getWidth()) * 0.5 + this.texture.getWidth() / 2.0, (double)zone.getWidth() * 0.5 - this.texture.getWidth() / 2.0));
                plane.setTransY(zone.getNode().getTransY() - (double)zone.getHeight() * 0.5 - paddingHeight);
                if (borderType != BorderType.INNER) break;
                plane.setRotateZ(180.0);
                break;
            }
            case 1: {
                plane.setTransX(zone.getNode().getTransX() + (double)zone.getWidth() * 0.5 + paddingWidth);
                plane.setTransY(zone.getNode().getTransY() + UtilRandom.get((double)(-zone.getHeight()) * 0.5 + this.texture.getHeight() / 2.0, (double)zone.getHeight() * 0.5 - this.texture.getHeight() / 2.0));
                plane.setRotateZ(borderType == BorderType.OUTER ? 90.0 : 270.0);
                break;
            }
            case 3: {
                plane.setTransX(zone.getNode().getTransX() - UtilRandom.get((double)(-zone.getWidth()) * 0.5 + this.texture.getWidth() / 2.0, (double)zone.getWidth() * 0.5 - this.texture.getWidth() / 2.0));
                plane.setTransY(zone.getNode().getTransY() + (double)zone.getHeight() * 0.5 + paddingHeight);
                if (borderType != BorderType.OUTER) break;
                plane.setRotateZ(180.0);
                break;
            }
            case 2: {
                plane.setTransX(zone.getNode().getTransX() - (double)zone.getWidth() * 0.5 - paddingWidth);
                plane.setTransY(zone.getNode().getTransY() - UtilRandom.get((double)(-zone.getHeight()) * 0.5 + this.texture.getHeight() / 2.0, (double)zone.getHeight() * 0.5 - this.texture.getHeight() / 2.0));
                plane.setRotateZ(borderType == BorderType.OUTER ? 270.0 : 90.0);
            }
        }
        plane.setTransZ(zone.getNode().getTransZ() + 1.0);
        plane.getMaterial().setDiffuseColor(Color.rgb((int)UtilRandom.get_z(256), (int)UtilRandom.get_z(256), (int)UtilRandom.get_z(256)));
        plane.setMouseTransparent(true);
        return plane;
    }

    @Override
    protected void onAttached() {
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getChildren().addLast((Object)this.node);
    }

    @Override
    protected void onDetached() {
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getChildren().remove((Object)this.node);
    }

    public static enum BorderType {
        INNER,
        OUTER;

    }

    public static enum BorderPosition {
        TOP,
        RIGHT,
        LEFT,
        BOTTOM;

    }
}

