/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.gfx;

import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import javafx.scene.paint.Material;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.Sphere;
import open.batoru.ImageCache;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.FieldData;
import open.batoru.game.FieldZoneSpinner;
import open.batoru.game.Zone;
import open.batoru.game._3d.Group3D;
import open.batoru.game._3d.Plane;
import open.batoru.game.animations.AnimationSpinnerRotate;
import open.batoru.game.gfx.GFX;
import open.batoru.ui.UI;

public class GFXZoneSpinner
extends GFX {
    private final Game.GamePlayerRole rolePlayer;
    private final FieldZoneSpinner spinner;

    public GFXZoneSpinner(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, AnimationSpinnerRotate aniRotate, Group3D ... spinNodes) {
        Zone zone = FieldData.getZoneByLocation(rolePlayer, location);
        if (zone == null) {
            throw new IllegalArgumentException();
        }
        this.rolePlayer = rolePlayer;
        this.spinner = new FieldZoneSpinner(zone, spinNodes);
        this.spinner.setRotateAnimation(aniRotate);
    }

    @Override
    protected void onAttached() {
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getChildren().add((Object)this.spinner);
        this.spinner.startRotation();
    }

    @Override
    protected void onDetached() {
        this.spinner.stopAnimations();
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByRole(this.rolePlayer).getChildren().remove((Object)this.spinner);
    }

    public static class GFXFlatSpinnerObject
    extends Group3D {
        public GFXFlatSpinnerObject(String textureName) {
            this(textureName, null);
        }

        public GFXFlatSpinnerObject(String textureName, int[] colorsRGB) {
            Image texture = ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath(textureName));
            Plane plane = new Plane((int)texture.getWidth(), (int)texture.getHeight(), texture);
            if (colorsRGB != null) {
                plane.getMaterial().setDiffuseColor(Color.rgb((int)colorsRGB[0], (int)colorsRGB[1], (int)colorsRGB[2]));
            }
            this.getChildren().add((Object)plane);
        }
    }

    public static class GFXSphericalSpinnerObject
    extends Group3D {
        public GFXSphericalSpinnerObject(int radius, int glowRadius, int divisions) {
            this(radius, glowRadius, divisions, null);
        }

        public GFXSphericalSpinnerObject(int radius, int glowRadius, int divisions, int[] colorsRGB) {
            Sphere sphere = new Sphere((double)radius, divisions);
            if (colorsRGB != null) {
                sphere.setMaterial((Material)new PhongMaterial(Color.rgb((int)colorsRGB[0], (int)colorsRGB[1], (int)colorsRGB[2])));
            }
            this.getChildren().add((Object)sphere);
            if (glowRadius > radius) {
                Plane glow = new Plane(glowRadius * 2, ImageCache.INSTANCE.getImage("textures/zones/field_background.png"));
                glow.setRotateX(30.0);
                if (colorsRGB != null) {
                    glow.getMaterial().setDiffuseColor(Color.rgb((int)colorsRGB[0], (int)colorsRGB[1], (int)colorsRGB[2]));
                }
                this.getChildren().add((Object)glow);
            }
        }
    }
}

