/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.gfx;

import javafx.scene.image.Image;
import javafx.scene.paint.Color;
import open.batoru.ImageCache;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.FieldData;
import open.batoru.game.Zone;
import open.batoru.game._3d.Plane;
import open.batoru.game.gfx.GFX;
import open.batoru.ui.UI;

public class GFXZoneWall
extends GFX {
    private final Zone zone;
    private final Image texture;
    private final int[] colorRGB;
    private Plane plane;

    public GFXZoneWall(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, String textureName) {
        this(rolePlayer, location, textureName, null);
    }

    public GFXZoneWall(Game.GamePlayerRole rolePlayer, GameConst.CardLocation location, String textureName, int[] colorRGB) {
        this.zone = FieldData.getZoneByLocation(rolePlayer, location);
        if (this.zone == null) {
            throw new IllegalArgumentException();
        }
        this.texture = ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("zones/barrier/" + textureName));
        this.colorRGB = colorRGB;
    }

    @Override
    protected void onAttached() {
        this.plane = new Plane(this.zone.getWidth(), 250, this.texture);
        if (this.colorRGB != null) {
            this.plane.getMaterial().setDiffuseColor(Color.rgb((int)this.colorRGB[0], (int)this.colorRGB[1], (int)this.colorRGB[2]));
        }
        this.plane.setMouseTransparent(true);
        this.plane.setRotateX(90.0);
        this.plane.setTransX(this.zone.getNode().getTransX());
        this.plane.setTransY(this.zone.getNode().getTransY() - (double)this.zone.getHeight() * 0.5);
        this.plane.setTransZ(this.zone.getNode().getTransZ() - 125.0);
        if (this.zone.isFlipped()) {
            this.plane.setRotateZ(180.0);
        }
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByZoneFlip(this.zone.isFlipped()).getChildren().add((Object)this.plane);
    }

    @Override
    protected void onDetached() {
        UI.getTabGame().getFieldScene().getGameField().getPlayerFieldByZoneFlip(this.zone.isFlipped()).getChildren().remove((Object)this.plane);
    }
}

