/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.Pane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.game.overlay.OverlayCardPreview;
import open.batoru.game.overlay.OverlayDisconnectedScreen;
import open.batoru.game.overlay.OverlayGameControls;
import open.batoru.game.overlay.OverlayGameMessage;
import open.batoru.game.overlay.OverlaySpecControls;
import open.batoru.game.overlay.OverlayWinScreen;
import open.batoru.game.overlay.effects.OverlayEffectsSidebar;
import open.batoru.game.overlay.log.OverlayGameLog;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowReport;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.FX;
import open.batoru.ui.UIConst;
import open.batoru.ui.UtilDispose;

public class FieldSceneOverlay
implements Disposable {
    private final StackPane root = new StackPane();
    private final OverlayCardPreview cardPreview = new OverlayCardPreview();
    private final StackPane fieldOverlay = new StackPane();
    private final VBox containerWindows = new VBox();
    private final OverlayEffectsSidebar effectsSideBar = new OverlayEffectsSidebar();
    private final Pane effectsPane = new Pane();
    private final OverlayGameLog gameLog = new OverlayGameLog();
    private final OverlayGameControls gameControls = new OverlayGameControls();
    private OverlaySpecControls specControls;
    private final Button buttonReport;
    private OverlayWindowReport windowReport;
    private final StackPane blackScreen = new StackPane();
    private OverlayWinScreen winScreen;
    private OverlayDisconnectedScreen disconnectedScreen;
    private OverlayGameMessage gameMessage;

    public FieldSceneOverlay() {
        this.root.setPickOnBounds(false);
        this.fieldOverlay.setPadding(new Insets(5.0));
        this.fieldOverlay.setPickOnBounds(false);
        StackPane.setMargin((Node)this.fieldOverlay, (Insets)new Insets(0.0, 0.0, 0.0, 265.0));
        UtilDispose.TEMP.attachChildDisposeListener((Node)this.fieldOverlay);
        this.effectsPane.setPickOnBounds(false);
        this.containerWindows.setAlignment(Pos.TOP_CENTER);
        this.containerWindows.setPadding(new Insets(5.0));
        this.containerWindows.setSpacing(15.0);
        this.containerWindows.setMaxWidth(700.0);
        this.containerWindows.setPickOnBounds(false);
        UtilDispose.TEMP.attachChildDisposeListener((Node)this.containerWindows);
        StackPane.setAlignment((Node)this.gameControls, (Pos)Pos.CENTER_RIGHT);
        StackPane.setAlignment((Node)this.gameLog, (Pos)Pos.CENTER_RIGHT);
        StackPane.setMargin((Node)this.gameLog, (Insets)new Insets(0.0, -375.0, 0.0, 0.0));
        StackPane.setAlignment((Node)this.effectsSideBar, (Pos)Pos.CENTER_LEFT);
        StackPane.setAlignment((Node)this.cardPreview, (Pos)Pos.CENTER_LEFT);
        this.buttonReport = OverlayWindow.createButton("\ud83d\udea9 " + LanguageParser.getString("UI_GAME_REPORT_BUTTON"));
        this.buttonReport.setMinWidth(120.0);
        this.buttonReport.setOnAction(e -> this.toggleReportWindow());
        StackPane.setAlignment((Node)this.buttonReport, (Pos)Pos.TOP_RIGHT);
        StackPane.setMargin((Node)this.buttonReport, (Insets)new Insets(5.0, 80.0, 0.0, 0.0));
        this.root.getChildren().addAll((Object[])new Node[]{this.cardPreview, this.fieldOverlay, this.buttonReport});
        this.blackScreen.setBackground(UIConst.Style.BACKGROUND_BLACK_SCREEN);
    }

    public void toggleReportWindow() {
        if (this.windowReport == null) {
            this.windowReport = new OverlayWindowReport();
            StackPane.setAlignment((Node)this.windowReport, (Pos)Pos.TOP_CENTER);
            StackPane.setMargin((Node)this.windowReport, (Insets)new Insets(100.0, 0.0, 0.0, 0.0));
            this.root.getChildren().add((Object)this.windowReport);
        } else {
            this.windowReport.dispose();
            this.root.getChildren().remove((Object)this.windowReport);
            this.windowReport = null;
        }
    }

    public void showGameMessage(String message) {
        this.showGameMessage(message, true);
    }

    public void showGameMessage(String message, boolean playAnimation) {
        FX.run(() -> {
            if (this.gameMessage != null) {
                this.gameMessage.stopAnimation();
                this.root.getChildren().remove((Object)this.gameMessage);
            }
            if (message != null && !message.isBlank()) {
                this.gameMessage = new OverlayGameMessage(message);
                this.root.getChildren().add((Object)this.gameMessage);
                if (playAnimation) {
                    this.gameMessage.playAnimation();
                }
            } else {
                this.gameMessage = null;
            }
        });
    }

    public void initGameNodes() {
        if (this.fieldOverlay.getChildren().contains((Object)this.effectsPane)) {
            return;
        }
        this.fieldOverlay.getChildren().addAll((Object[])new Node[]{this.effectsSideBar, this.effectsPane, this.containerWindows, this.gameLog, this.gameControls});
    }

    public void updateSpectatorControls(int specCount) {
        if (specCount > 0) {
            if (this.specControls == null) {
                this.specControls = new OverlaySpecControls();
                StackPane.setAlignment((Node)this.specControls, (Pos)Pos.CENTER_RIGHT);
                StackPane.setMargin((Node)this.specControls, (Insets)new Insets(0.0, 75.0, 0.0, 0.0));
                this.fieldOverlay.getChildren().add((Object)this.specControls);
                StackPane.setMargin((Node)this.buttonReport, (Insets)new Insets(5.0, 180.0, 0.0, 0.0));
            }
            this.specControls.setSpecCount(specCount);
        } else if (specCount == 0 && this.specControls != null) {
            this.fieldOverlay.getChildren().remove((Object)this.specControls);
            this.specControls.dispose();
            this.specControls = null;
            StackPane.setMargin((Node)this.buttonReport, (Insets)new Insets(5.0, 80.0, 0.0, 0.0));
        }
    }

    public void showBlackScreen(boolean set) {
        if (set && !this.root.getChildren().contains((Object)this.blackScreen)) {
            this.root.getChildren().add(this.root.getChildren().indexOf((Object)this.buttonReport), (Object)this.blackScreen);
        } else if (!set && this.root.getChildren().contains((Object)this.blackScreen)) {
            this.root.getChildren().remove((Object)this.blackScreen);
            this.blackScreen.getChildren().clear();
        }
    }

    public StackPane getBlackScreenNode() {
        return this.blackScreen;
    }

    public void showWinScreen(String message, String subtitle) {
        if (this.winScreen != null) {
            this.hideWinScreen();
        }
        if (message == null) {
            return;
        }
        this.winScreen = new OverlayWinScreen(message, subtitle);
        this.root.getChildren().addFirst((Object)this.winScreen);
        this.gameControls.disableControls(true);
        FX.run(() -> {
            this.containerWindows.getChildren().clear();
            OverlayWindow.clearWindows();
        });
    }

    public void hideWinScreen() {
        this.winScreen.dispose();
        this.root.getChildren().remove((Object)this.winScreen);
        this.winScreen = null;
    }

    public OverlayWinScreen getWinScreen() {
        return this.winScreen;
    }

    public void showDisconnectedScreen() {
        if (this.disconnectedScreen != null || this.winScreen != null) {
            return;
        }
        this.showGameMessage(LanguageParser.getString(Game.getCurrentGame().getFakeReceiver() == null ? "UI_GAME_MESSAGE_DISCONNECT" : "UI_GAME_MESSAGE_DISCONNECT_SPEC"));
        this.disconnectedScreen = new OverlayDisconnectedScreen();
        this.root.getChildren().addFirst((Object)this.disconnectedScreen);
        this.disconnectedScreen.startCountdownTimer();
        this.gameControls.disableControls(true);
        this.gameControls.getButtonSurrender().setDisable(false);
    }

    public void hideDisconnectedScreen() {
        if (this.disconnectedScreen == null) {
            return;
        }
        this.showGameMessage(null);
        this.disconnectedScreen.dispose();
        this.root.getChildren().remove((Object)this.disconnectedScreen);
        this.disconnectedScreen = null;
        this.gameControls.disableControls(false);
        if (Game.getCurrentGame().getGameRules().wasRetireUsed()) {
            this.gameControls.getButtonRetire().setDisable(true);
        }
    }

    public OverlayDisconnectedScreen getDisconnectedScreen() {
        return this.disconnectedScreen;
    }

    public OverlayEffectsSidebar getEffectsSidebar() {
        return this.effectsSideBar;
    }

    public OverlayGameLog getGameLog() {
        return this.gameLog;
    }

    public OverlayGameControls getGameControls() {
        return this.gameControls;
    }

    public StackPane getRootNode() {
        return this.root;
    }

    public StackPane getNode() {
        return this.fieldOverlay;
    }

    public VBox getWindowsNode() {
        return this.containerWindows;
    }

    public Pane getEffectsPane() {
        return this.effectsPane;
    }

    public OverlayCardPreview getCardPreview() {
        return this.cardPreview;
    }

    public void setReportButtonVisible(boolean set) {
        this.buttonReport.setVisible(set);
        this.buttonReport.setManaged(set);
    }

    @Override
    public void dispose() {
        this.showGameMessage(null);
        this.showBlackScreen(false);
        this.buttonReport.setOnAction(null);
        if (this.windowReport != null) {
            this.windowReport.dispose();
            this.windowReport = null;
        }
        if (this.winScreen != null) {
            this.winScreen.dispose();
            this.winScreen = null;
        }
        if (this.disconnectedScreen != null) {
            this.disconnectedScreen.dispose();
            this.disconnectedScreen = null;
        }
        this.cardPreview.dispose();
        this.effectsPane.getChildren().clear();
        this.containerWindows.getChildren().clear();
        OverlayWindow.clearWindows();
        this.fieldOverlay.getChildren().clear();
        this.specControls = null;
    }
}

