/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay;

import javafx.animation.Animation;
import javafx.animation.SequentialTransition;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import open.batoru.core.Game;
import open.batoru.game.animations.AnimationTextShrink;
import open.batoru.game.animations.AnimationWait;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class OverlayAlertMessage {
    private static SequentialTransition seqAniCurrentAlert;
    private static Text textCurrentAlert;

    public static void show(String message) {
        OverlayAlertMessage.show(message, Color.KHAKI);
    }

    public static void show(String message, Color color) {
        OverlayAlertMessage.show(message, color, 200);
    }

    public static void show(String message, Color color, int holdTime) {
        if (Game.getCurrentGame().getFakeReceiver() != null) {
            return;
        }
        if (seqAniCurrentAlert != null) {
            seqAniCurrentAlert.stop();
            UI.getTabGame().getFieldSceneOverlay().getRootNode().getChildren().remove((Object)textCurrentAlert);
        }
        Text text = new Text(message);
        text.setTextAlignment(TextAlignment.CENTER);
        text.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)32.0));
        text.setFill((Paint)color);
        StackPane.setAlignment((Node)text, (Pos)Pos.BOTTOM_CENTER);
        StackPane.setMargin((Node)text, (Insets)new Insets(0.0, 0.0, 160.0, 0.0));
        UI.getTabGame().getFieldSceneOverlay().getRootNode().getChildren().add((Object)text);
        SequentialTransition seqAni = new SequentialTransition();
        AnimationTextShrink aniShrink = new AnimationTextShrink(text);
        AnimationWait aniWait = new AnimationWait(holdTime);
        seqAni.getChildren().addAll((Object[])new Animation[]{aniShrink, aniWait});
        seqAni.setOnFinished(e -> {
            UI.getTabGame().getFieldSceneOverlay().getRootNode().getChildren().remove((Object)text);
            textCurrentAlert = null;
            seqAniCurrentAlert = null;
        });
        seqAni.play();
        textCurrentAlert = text;
        seqAniCurrentAlert = seqAni;
    }
}

