/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay;

import java.net.UnknownHostException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javafx.animation.FadeTransition;
import javafx.animation.RotateTransition;
import javafx.application.Platform;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonBar;
import javafx.scene.control.ButtonType;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.util.Duration;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.Player;
import open.batoru.core.gameplay.actions.ActionGameEnd;
import open.batoru.game.animations.AnimationUITextFlash;
import open.batoru.game.overlay.OverlayDisconnectedScreen;
import open.batoru.networking.connection.GameSendPlayerSurrenderAttempt;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;
import open.batoru.ui.UIConst;

public class OverlayGameControls
extends StackPane
implements Disposable {
    private final Text textTurnCount;
    private final Text textGameDuration;
    private final Button buttonLogGame;
    private final Button buttonChat;
    private final Text textCurrentPhase;
    private final Text textTurnPlayerArrowTop;
    private final Text textTurnPlayerArrowBottom;
    private final Button buttonSurrender;
    private final Button buttonNextPhase;
    private final Button buttonRetire;
    private final Text textWaitServerRequest;
    private final StackPane gradient = new StackPane();
    private int gameDuration;
    private ScheduledExecutorService executorGameDurationTimer;
    private AnimationUITextFlash aniPhaseButtonFlash;
    private FadeTransition aniGradientFlash;
    private RotateTransition aniWaitServerRequestRotate;
    private long lastNextPhaseClick;
    private static final int NEXT_PHASE_BUTTON_COOLDOWN = 300;

    public OverlayGameControls() {
        this.setMaxWidth(200.0);
        this.setPickOnBounds(false);
        VBox containerTop = new VBox();
        containerTop.setAlignment(Pos.TOP_CENTER);
        containerTop.setSpacing(5.0);
        containerTop.setPickOnBounds(false);
        this.textTurnCount = new Text();
        this.textTurnCount.setTextAlignment(TextAlignment.CENTER);
        this.textTurnCount.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)14.0));
        this.textTurnCount.setFill((Paint)Color.KHAKI);
        this.textGameDuration = new Text();
        this.textGameDuration.setTextAlignment(TextAlignment.CENTER);
        this.textGameDuration.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)10.0));
        this.textGameDuration.setFill((Paint)Color.KHAKI);
        VBox boxButtons = new VBox();
        boxButtons.setAlignment(Pos.CENTER);
        boxButtons.setSpacing(10.0);
        boxButtons.setPickOnBounds(false);
        this.buttonLogGame = OverlayGameControls.createButton("\ud83d\udcdc");
        this.buttonLogGame.setOnAction(e -> UI.getTabGame().getFieldSceneOverlay().getGameLog().toggle());
        this.buttonChat = OverlayGameControls.createButton("\ud83d\udcac");
        this.buttonChat.setDisable(true);
        this.buttonSurrender = OverlayGameControls.createButton("\ud83e\udd1d");
        this.buttonSurrender.setOnAction(e -> {
            if (Game.getCurrentGame().getFakeReceiver() != null || Game.getCurrentGame().getGameState() != Game.GameState.IN_PROGRESS) {
                return;
            }
            OverlayDisconnectedScreen disconnectedScreen = UI.getTabGame().getFieldSceneOverlay().getDisconnectedScreen();
            if (disconnectedScreen != null && disconnectedScreen.hasDefaultCountdownTimePassed()) {
                UI.getTabGame().closeGame(true);
                return;
            }
            Alert alert = new Alert(Alert.AlertType.CONFIRMATION, LanguageParser.getString("UI_ALERT_SURRENDER"), new ButtonType[]{ButtonType.YES, ButtonType.NO});
            alert.setHeaderText(LanguageParser.getString("UI_ALERT_SURRENDER_HEADER"));
            alert.showAndWait();
            if (((ButtonType)alert.getResult()).getButtonData() != ButtonBar.ButtonData.YES) {
                return;
            }
            this.buttonSurrender.setDisable(true);
            try {
                GameSendPlayerSurrenderAttempt attempt = new GameSendPlayerSurrenderAttempt();
                Player.getNetworkFrame().getGameReceiver().setPacketRedirect(attempt, pp -> true, pp -> {
                    if (pp.getDataArgsNum() < 2 || !pp.getDataArgument(0).equals("!1")) {
                        this.buttonSurrender.setDisable(false);
                        return;
                    }
                    ActionGameEnd.executeGameEnd(LanguageParser.getString("UI_GAME_WINSCREEN_LOSE"));
                    UI.getTabGame().getFieldSceneOverlay().getWinScreen().receiveReplayData(pp.getDataArgument(1));
                });
                attempt.send();
            }
            catch (UnknownHostException ex) {
                System.err.println(ex.getMessage());
            }
        });
        boxButtons.getChildren().addAll((Object[])new Node[]{this.buttonLogGame, this.buttonChat, this.buttonSurrender});
        containerTop.getChildren().addAll((Object[])new Node[]{this.textTurnCount, this.textGameDuration, boxButtons});
        VBox containerCenter = new VBox();
        containerCenter.setAlignment(Pos.CENTER);
        containerCenter.setSpacing(10.0);
        containerCenter.setPickOnBounds(false);
        this.textTurnPlayerArrowTop = new Text("\u25b2");
        this.textTurnPlayerArrowTop.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (double)12.0));
        this.textTurnPlayerArrowTop.setFill((Paint)Color.KHAKI);
        this.textTurnPlayerArrowTop.setVisible(false);
        this.textCurrentPhase = new Text();
        this.textCurrentPhase.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)12.0));
        this.textCurrentPhase.setFill((Paint)Color.KHAKI);
        this.buttonNextPhase = OverlayGameControls.createButton("\u276f\u276f");
        this.buttonRetire = OverlayGameControls.createButton("\ud83d\uddd1");
        this.buttonRetire.setFont(Font.loadFont((String)"file:fonts/Symbola-12.ttf", (double)24.0));
        this.textTurnPlayerArrowBottom = new Text("\u25bc");
        this.textTurnPlayerArrowBottom.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (double)12.0));
        this.textTurnPlayerArrowBottom.setFill((Paint)Color.KHAKI);
        this.textTurnPlayerArrowBottom.setVisible(false);
        this.buttonNextPhase.setOnAction(e -> {
            if (Game.getCurrentGame().getFakeReceiver() != null || System.currentTimeMillis() - this.lastNextPhaseClick < 300L) {
                return;
            }
            this.lastNextPhaseClick = System.currentTimeMillis();
            Game.getCurrentGame().getPlayerControl().onManualPhaseNext();
        });
        this.buttonRetire.setOnAction(e -> {
            if (Game.getCurrentGame().getFakeReceiver() == null) {
                Game.getCurrentGame().getPlayerControl().onManualRetire();
            }
        });
        containerCenter.getChildren().addAll((Object[])new Node[]{this.textTurnPlayerArrowTop, this.textCurrentPhase, this.buttonNextPhase, this.buttonRetire, this.textTurnPlayerArrowBottom});
        VBox containerBottom = new VBox();
        containerBottom.setAlignment(Pos.BOTTOM_CENTER);
        containerBottom.setPadding(new Insets(0.0, 0.0, 5.0, 0.0));
        containerBottom.setSpacing(10.0);
        containerBottom.setPickOnBounds(false);
        this.textWaitServerRequest = new Text("\u231b");
        this.textWaitServerRequest.setTextAlignment(TextAlignment.CENTER);
        this.textWaitServerRequest.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)26.0));
        this.textWaitServerRequest.setFill((Paint)Color.KHAKI);
        this.textWaitServerRequest.setVisible(false);
        containerBottom.getChildren().addAll((Object[])new Node[]{this.textWaitServerRequest});
        StackPane controls = new StackPane();
        controls.setMaxWidth(75.0);
        controls.getChildren().addAll((Object[])new Node[]{containerTop, containerCenter, containerBottom});
        StackPane.setAlignment((Node)controls, (Pos)Pos.CENTER_RIGHT);
        this.gradient.setMouseTransparent(true);
        this.gradient.setMinWidth(this.getMaxWidth());
        this.gradient.setMaxWidth(this.getMaxWidth());
        this.gradient.setBackground(UIConst.Style.BACKGROUND_OVERLAY_SIDE_GRADIENT);
        this.gradient.setOpacity(0.0);
        StackPane.setMargin((Node)this.gradient, (Insets)new Insets(-5.0));
        StackPane.setAlignment((Node)this.gradient, (Pos)Pos.CENTER_RIGHT);
        this.getChildren().addAll((Object[])new Node[]{this.gradient, controls});
    }

    public static Button createButton(String text) {
        Button button = new Button(text);
        button.setPadding(Insets.EMPTY);
        button.setFont(Font.loadFont((String)"file:fonts/Symbola-12.ttf", (double)16.0));
        button.setPrefSize(40.0, 40.0);
        button.getStyleClass().addAll((Object[])new String[]{"button_game_ui", "button_game_ui_bar"});
        return button;
    }

    public void setTurnCountNum(int turnCount) {
        this.textTurnCount.setText(LanguageParser.getString("UI_GAME_INFO_TURN") + "\n\u231b " + turnCount);
    }

    public void setCurrentPhaseText(String text) {
        this.textCurrentPhase.setText(text);
    }

    public void setWaitingServerRequest(boolean set) {
        this.textWaitServerRequest.setVisible(set);
        if (set && this.aniWaitServerRequestRotate == null) {
            this.aniWaitServerRequestRotate = new RotateTransition(Duration.millis((double)1000.0), (Node)this.textWaitServerRequest);
            this.aniWaitServerRequestRotate.setCycleCount(-1);
            this.aniWaitServerRequestRotate.setFromAngle(180.0);
            this.aniWaitServerRequestRotate.setToAngle(0.0);
            this.aniWaitServerRequestRotate.play();
        } else if (!set && this.aniWaitServerRequestRotate != null) {
            this.aniWaitServerRequestRotate.stop();
            this.aniWaitServerRequestRotate = null;
        }
    }

    public void setPhaseButtonHighlight(boolean set) {
        if (set && this.aniPhaseButtonFlash == null) {
            this.aniPhaseButtonFlash = new AnimationUITextFlash(this.buttonNextPhase, this.textCurrentPhase);
            this.aniPhaseButtonFlash.play();
            this.aniGradientFlash = this.newBlinkAnimation((Node)this.gradient);
            this.aniGradientFlash.play();
        } else if (this.aniPhaseButtonFlash != null) {
            this.aniPhaseButtonFlash.stop();
            this.aniPhaseButtonFlash = null;
            this.aniGradientFlash.stop();
            this.aniGradientFlash = null;
            this.gradient.setOpacity(0.0);
        }
    }

    private FadeTransition newBlinkAnimation(Node node) {
        FadeTransition ani = new FadeTransition(Duration.millis((double)1000.0), node);
        ani.setAutoReverse(true);
        ani.setCycleCount(-1);
        ani.setFromValue(0.0);
        ani.setToValue(0.25);
        return ani;
    }

    public void setActiveTurnPlayerArrow(Game.GamePlayerRole rolePlayer) {
        this.textTurnPlayerArrowTop.setVisible(rolePlayer != Game.getCurrentGame().getPlayerRole());
        this.textTurnPlayerArrowBottom.setVisible(!this.textTurnPlayerArrowTop.isVisible());
    }

    public void startGameDurationTimer() {
        if (this.executorGameDurationTimer != null) {
            return;
        }
        this.executorGameDurationTimer = Executors.newScheduledThreadPool(1);
        this.executorGameDurationTimer.scheduleAtFixedRate(() -> {
            if (Game.getCurrentGame() == null || Game.getCurrentGame().getGameState() != Game.GameState.IN_PROGRESS) {
                this.executorGameDurationTimer.shutdown();
                this.executorGameDurationTimer = null;
                return;
            }
            ++this.gameDuration;
            Platform.runLater(() -> this.textGameDuration.setText(String.format("%02d:%02d:%02d", this.gameDuration / 3600, this.gameDuration / 60 % 60, this.gameDuration % 60)));
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    public void stopGameDurationTimer() {
        if (this.executorGameDurationTimer == null) {
            return;
        }
        this.executorGameDurationTimer.shutdown();
        this.executorGameDurationTimer = null;
    }

    public Button getButtonSurrender() {
        return this.buttonSurrender;
    }

    public Button getButtonNextPhase() {
        return this.buttonNextPhase;
    }

    public Button getButtonRetire() {
        return this.buttonRetire;
    }

    public void disableControls(boolean set) {
        this.buttonSurrender.setDisable(set);
        this.buttonRetire.setDisable(set);
    }

    @Override
    public void dispose() {
        this.stopGameDurationTimer();
        this.buttonLogGame.setOnAction(null);
        this.buttonChat.setOnAction(null);
        this.buttonSurrender.setOnAction(null);
        this.buttonNextPhase.setOnAction(null);
        this.buttonRetire.setOnAction(null);
    }
}

