/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.ThinkingText;
import open.batoru.ui.UIConst;

public class OverlayGameMessage
extends StackPane {
    private final ThinkingText textWaiting;

    public OverlayGameMessage(String message) {
        this.setBackground(UIConst.Style.BACKGROUND_TRANSPARENT_OVERLAY);
        Group group = new Group();
        StackPane container = new StackPane();
        container.setBackground(UIConst.Style.BACKGROUND_TRANSPARENT_OVERLAY_MESSAGE);
        container.setAlignment(Pos.CENTER_LEFT);
        container.setPadding(new Insets(5.0));
        this.textWaiting = new ThinkingText(message);
        this.textWaiting.setFill((Paint)Color.WHITE);
        this.textWaiting.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)20.0));
        container.getChildren().add((Object)this.textWaiting);
        group.getChildren().add((Object)container);
        this.getChildren().add((Object)group);
        container.setMinWidth(this.textWaiting.getBoundsInLocal().getWidth() + 35.0);
        this.setMouseTransparent(true);
    }

    public void playAnimation() {
        this.textWaiting.playAnimation();
    }

    public void stopAnimation() {
        this.textWaiting.stopAnimation();
    }
}

