/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay;

import javafx.animation.Transition;
import javafx.beans.value.ChangeListener;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.util.Duration;

public class OverlayOpeningBackground
extends StackPane {
    private final Rectangle rectangle = new Rectangle();
    private AnimationGrow aniGrow;
    private ChangeListener<Number> listener;

    public OverlayOpeningBackground() {
        this.rectangle.setStroke((Paint)Color.WHITE);
        this.rectangle.setFill((Paint)Color.TRANSPARENT);
        this.rectangle.setStrokeWidth(2.0);
        this.getChildren().add((Object)this.rectangle);
    }

    public void playAnimation() {
        this.aniGrow = new AnimationGrow(this.rectangle, this);
        this.aniGrow.setCycleCount(-1);
        this.aniGrow.play();
        this.listener = (ov, oldValue, newValue) -> this.aniGrow.playFromStart();
        this.widthProperty().addListener(this.listener);
        this.heightProperty().addListener(this.listener);
    }

    public void stopAnimation() {
        this.aniGrow.stop();
        this.widthProperty().removeListener(this.listener);
        this.heightProperty().removeListener(this.listener);
    }

    private static class AnimationGrow
    extends Transition {
        private final Rectangle rectangle;
        private final StackPane stackPane;

        public AnimationGrow(Rectangle rectangle, StackPane stackPane) {
            this.rectangle = rectangle;
            this.stackPane = stackPane;
            this.setCycleDuration(Duration.millis((double)500.0));
        }

        protected void interpolate(double frac) {
            this.rectangle.setWidth(this.stackPane.getWidth() * frac);
            this.rectangle.setHeight(this.stackPane.getHeight() * frac);
        }
    }
}

