/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay;

import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import open.batoru.Settings;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.networking.service.GameDataDownloadService;
import open.batoru.parsers.LanguageParser;
import open.batoru.replays.UtilReplays;
import open.batoru.ui.UI;
import open.batoru.ui.UIConst;

public class OverlayWinScreen
extends StackPane
implements Disposable {
    private final Button buttonEndGame;
    private final Button buttonReplay;

    public OverlayWinScreen(String message, String subtitle) {
        this.setBackground(UIConst.Style.BACKGROUND_OVERLAY);
        VBox boxMessage = new VBox();
        boxMessage.setSpacing(10.0);
        Text text = new Text(message);
        text.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)72.0));
        text.setFill((Paint)Color.KHAKI);
        this.getChildren().add((Object)text);
        if (subtitle != null) {
            Text textSub = new Text(subtitle);
            textSub.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)16.0));
            textSub.setFill((Paint)Color.WHITE);
            this.getChildren().add((Object)textSub);
            StackPane.setMargin((Node)textSub, (Insets)new Insets(110.0, 0.0, 0.0, 0.0));
        }
        this.buttonEndGame = OverlayWindow.createButton(LanguageParser.getString("UI_GAME_MESSAGE_END_BUTTON"));
        this.buttonEndGame.setOnAction(e -> UI.getTabGame().closeGame(Game.getCurrentGame().getFakeReceiver() == null));
        StackPane.setAlignment((Node)this.buttonEndGame, (Pos)Pos.BOTTOM_CENTER);
        StackPane.setMargin((Node)this.buttonEndGame, (Insets)new Insets(0.0, 0.0, 220.0, 0.0));
        this.buttonReplay = OverlayWindow.createButton(LanguageParser.getString("UI_GAME_MESSAGE_END_BUTTON_REPLAY_WAIT"));
        this.buttonReplay.setDisable(true);
        StackPane.setAlignment((Node)this.buttonReplay, (Pos)Pos.BOTTOM_CENTER);
        StackPane.setMargin((Node)this.buttonReplay, (Insets)new Insets(0.0, 0.0, 180.0, 0.0));
        if (Game.getCurrentGame().getGameServerPortOffset() == 0 && Game.getCurrentGame().getSourceReplayChecksum() == null) {
            this.buttonReplay.setVisible(false);
            this.buttonReplay.setManaged(false);
        }
        this.getChildren().addAll((Object[])new Node[]{this.buttonEndGame, this.buttonReplay});
    }

    public final void receiveReplayData(String checksum) {
        if (checksum == null || checksum.isEmpty() || checksum.equals("!3")) {
            this.buttonReplay.setText(LanguageParser.getString("UI_GAME_MESSAGE_END_BUTTON_REPLAY_NO"));
            return;
        }
        this.buttonReplay.setText(LanguageParser.getString("UI_GAME_MESSAGE_END_BUTTON_REPLAY_DOWNLOAD"));
        this.buttonReplay.setDisable(false);
        this.buttonReplay.setOnAction(e -> {
            File newFile;
            if (!Settings.INSTANCE.shouldAutoSaveReplays() || Game.getCurrentGame().getFakeReceiver() != null) {
                newFile = UtilReplays.showSaveReplayDialog(Game.getCurrentGame().getGameId());
            } else {
                Path directory;
                try {
                    directory = Path.of("replays/", new String[0]);
                    if (!Files.exists(directory, new LinkOption[0])) {
                        Files.createDirectory(directory, new FileAttribute[0]);
                    }
                }
                catch (IOException ex) {
                    directory = Path.of(".", new String[0]);
                }
                newFile = directory.resolve("game-" + Game.getCurrentGame().getGameId() + ".replay").toFile();
            }
            if (newFile == null) {
                return;
            }
            this.buttonReplay.setText(LanguageParser.getString("UI_GAME_MESSAGE_END_BUTTON_REPLAY_DOWNLOAD_PROG"));
            this.buttonReplay.setDisable(true);
            GameDataDownloadService service = new GameDataDownloadService(checksum, pathTemp -> {
                this.buttonReplay.setText(LanguageParser.getString("UI_GAME_MESSAGE_END_BUTTON_REPLAY_DOWNLOAD"));
                this.buttonReplay.setDisable(false);
                UtilReplays.saveReplay(pathTemp, newFile);
            });
            service.start();
        });
        if (Settings.INSTANCE.shouldAutoSaveReplays()) {
            this.buttonReplay.fire();
        }
    }

    @Override
    public void dispose() {
        this.buttonEndGame.setOnAction(null);
        this.buttonReplay.setOnAction(null);
    }
}

