/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import open.batoru.ImageCache;
import open.batoru.core.Disposable;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class LogEntryAbility
extends LogEntry
implements Disposable {
    private ImageView imageCard;
    private ToggleButton buttonSourceAbility;

    public LogEntryAbility(boolean isOwnCard, String imageSet, String cardName, String abilityDescription, String action) {
        this(isOwnCard, imageSet, cardName, null, abilityDescription, null, action);
    }

    public LogEntryAbility(boolean isOwnCard, String imageSet, String cardName, String abilitySourceImageSet, String abilityDescription, String abilitySourceDescription, String action) {
        StackPane backgrounds = new StackPane();
        backgrounds.getChildren().add((Object)LogEntry.createGradientBackground(true, isOwnCard));
        backgrounds.setOpacity(0.5);
        this.getChildren().add((Object)backgrounds);
        BorderPane borderPane = new BorderPane();
        borderPane.setPadding(new Insets(10.0));
        VBox containerCenter = new VBox();
        StackPane containerDesc = LogEntry.createCardAbilityDescription(abilityDescription);
        this.imageCard = LogEntry.createCardImage(imageSet);
        if (abilitySourceImageSet == null || abilityDescription.equals(abilitySourceDescription)) {
            borderPane.setLeft((Node)this.imageCard);
        } else {
            StackPane containerCardImage = new StackPane();
            this.buttonSourceAbility = new ToggleButton("\ud83d\udd17");
            this.buttonSourceAbility.setFont(Font.font((String)"file:fonts/Symbola-12.ttf", (double)14.0));
            this.buttonSourceAbility.setMinSize(24.0, 24.0);
            this.buttonSourceAbility.setMaxSize(24.0, 24.0);
            this.buttonSourceAbility.setPadding(Insets.EMPTY);
            this.buttonSourceAbility.setFocusTraversable(false);
            StackPane.setMargin((Node)this.buttonSourceAbility, (Insets)new Insets(0.0, 0.0, 5.0, 5.0));
            StackPane.setAlignment((Node)this.buttonSourceAbility, (Pos)Pos.BOTTOM_LEFT);
            containerCardImage.getChildren().addAll((Object[])new Node[]{this.imageCard, this.buttonSourceAbility});
            StackPane containerSourceAbility = LogEntry.createCardAbilityDescription(abilitySourceDescription);
            Image refImageCard = this.imageCard.getImage();
            this.buttonSourceAbility.setOnAction(e -> {
                boolean isSelected = this.buttonSourceAbility.isSelected();
                containerCenter.getChildren().set(1, (Object)(isSelected ? containerSourceAbility : containerDesc));
                this.imageCard.setImage(isSelected ? ImageCache.INSTANCE.getImage(abilitySourceImageSet) : refImageCard);
                this.imageCard.setOnMouseEntered(e2 -> UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(isSelected ? abilitySourceImageSet : imageSet));
            });
            borderPane.setLeft((Node)containerCardImage);
        }
        Text textCardName = new Text(cardName);
        textCardName.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)12.0));
        textCardName.setFill((Paint)Color.WHITE);
        textCardName.setWrappingWidth(250.0);
        textCardName.setTextAlignment(TextAlignment.CENTER);
        borderPane.setTop((Node)textCardName);
        BorderPane.setMargin((Node)textCardName, (Insets)new Insets(0.0, 0.0, 5.0, 0.0));
        BorderPane.setAlignment((Node)textCardName, (Pos)Pos.CENTER);
        containerCenter.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
        if (action != null) {
            Text textAction = new Text(action);
            textAction.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)12.0));
            textAction.setFill((Paint)Color.KHAKI);
            containerCenter.getChildren().add((Object)textAction);
            containerDesc.setMinHeight(70.0);
            containerDesc.setMaxHeight(70.0);
        }
        containerCenter.getChildren().add((Object)containerDesc);
        borderPane.setCenter((Node)containerCenter);
        BorderPane.setMargin((Node)containerCenter, (Insets)new Insets(0.0, 0.0, 0.0, 5.0));
        this.getChildren().add((Object)borderPane);
    }

    public LogEntryAbility(boolean isOwnCard) {
        this.setAlignment(Pos.CENTER_LEFT);
        StackPane background = LogEntry.createGradientBackground(true, isOwnCard);
        background.setOpacity(0.5);
        Text textAction = new Text("\ud83d\uddf2 " + LanguageParser.getString("UI_GAME_LOG_ABILITY_RESOLVE") + ":");
        textAction.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)12.0));
        textAction.setFill((Paint)Color.KHAKI);
        StackPane.setMargin((Node)textAction, (Insets)new Insets(5.0, 5.0, 5.0, 10.0));
        this.getChildren().addAll((Object[])new Node[]{background, textAction});
    }

    @Override
    public void dispose() {
        if (this.buttonSourceAbility != null) {
            this.buttonSourceAbility.setOnAction(null);
        }
        if (this.imageCard != null) {
            this.imageCard.setImage(null);
            this.imageCard.setOnMouseEntered(null);
        }
    }
}

