/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import open.batoru.core.Game;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.parsers.LanguageParser;

public class LogEntryAdvanceTurn
extends LogEntry {
    public LogEntryAdvanceTurn(Game.GamePlayerRole rolePlayer, int turnCount) {
        this.setPadding(new Insets(5.0));
        if (rolePlayer == Game.getCurrentGame().getPlayerRole()) {
            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)0, (int)255, (int)0, (double)0.25), null, null)}));
        } else {
            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)255, (int)0, (int)0, (double)0.25), null, null)}));
        }
        String username = Game.getCurrentGame().getRoom().getPlayerData(rolePlayer).getPlayerName();
        Text text = new Text("\u25c0\u25c0\u25c0\u25c0\u25c0 " + username + LanguageParser.getString("UI_GAME_LOG_TURN") + " \u25b6\u25b6\u25b6\u25b6\u25b6");
        text.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)12.0));
        text.setFill((Paint)Color.KHAKI);
        Text textTurnCount = new Text("\u231b " + turnCount);
        textTurnCount.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (double)12.0));
        textTurnCount.setFill((Paint)Color.WHITE);
        StackPane.setAlignment((Node)textTurnCount, (Pos)Pos.CENTER_RIGHT);
        this.getChildren().addAll((Object[])new Node[]{text, textTurnCount});
    }
}

