/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ToggleButton;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import open.batoru.core.Disposable;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class LogEntryCard
extends LogEntry
implements Disposable {
    private HBox contentCustom;
    private ToggleButton buttonSourceAbility;
    private final ImageView imageCardLeft;
    private final ImageView imageCardRight;

    public LogEntryCard(boolean isOwnCard, String imageSet, String cardName, String action, ArrowsDirection arrowsDirection) {
        this(isOwnCard, imageSet, cardName, false, null, false, null, false, false, false, action, arrowsDirection);
    }

    public LogEntryCard(boolean isOwnCard, String imageSet, String cardName, boolean isOwnCardSource, String imageSetSource, String action, ArrowsDirection arrowsDirection) {
        this(isOwnCard, imageSet, cardName, isOwnCardSource, imageSetSource, false, null, false, false, false, action, arrowsDirection);
    }

    public LogEntryCard(boolean isOwnCard, String imageSet, String cardName, boolean isOwnCardSource, String imageSetSource, boolean isSelfSource, String abilityDescription, boolean abilityIsConst, boolean hasCost, boolean isGuard, String action, ArrowsDirection arrowsDirection) {
        StackPane backgrounds = new StackPane();
        backgrounds.getChildren().add((Object)LogEntry.createGradientBackground(true, isOwnCard));
        if (imageSetSource != null) {
            backgrounds.getChildren().add((Object)LogEntry.createGradientBackground(false, isOwnCardSource));
        }
        if (abilityDescription != null) {
            backgrounds.setOpacity(0.5);
        }
        this.getChildren().add((Object)backgrounds);
        BorderPane borderPane = new BorderPane();
        borderPane.setPadding(new Insets(10.0));
        this.imageCardLeft = LogEntry.createCardImage(imageSet);
        borderPane.setLeft((Node)this.imageCardLeft);
        if (cardName != null) {
            Text textCardName = new Text(cardName);
            textCardName.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)12.0));
            textCardName.setFill((Paint)Color.WHITE);
            textCardName.setWrappingWidth(250.0);
            textCardName.setTextAlignment(TextAlignment.CENTER);
            borderPane.setTop((Node)textCardName);
            BorderPane.setMargin((Node)textCardName, (Insets)new Insets(0.0, 0.0, 5.0, 0.0));
            BorderPane.setAlignment((Node)textCardName, (Pos)Pos.CENTER);
        }
        VBox content = new VBox();
        content.setPadding(new Insets(10.0, 0.0, 0.0, 0.0));
        content.setAlignment(Pos.TOP_CENTER);
        content.setSpacing(5.0);
        if (action != null) {
            if (!action.isEmpty()) {
                Text textAction = new Text(action);
                textAction.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)14.0));
                textAction.setFill((Paint)Color.KHAKI);
                if (hasCost && isGuard) {
                    textAction.setText(LanguageParser.getString("UI_GAME_LOG_CARD_GUARD"));
                }
                content.getChildren().add((Object)textAction);
            }
            if (arrowsDirection != ArrowsDirection.NONE) {
                Text textArrows = new Text(arrowsDirection == ArrowsDirection.LEFT ? "\u25c0\u25c0\u25c0\u25c0\u25c0\u25c0" : "\u25b6\u25b6\u25b6\u25b6\u25b6\u25b6");
                textArrows.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (double)12.0));
                textArrows.setFill((Paint)Color.WHITE);
                content.getChildren().add((Object)textArrows);
            }
            this.contentCustom = new HBox();
            this.contentCustom.setAlignment(Pos.CENTER);
            this.contentCustom.setPadding(new Insets(5.0, 0.0, 0.0, 0.0));
            this.contentCustom.setSpacing(5.0);
            content.getChildren().add((Object)this.contentCustom);
        }
        borderPane.setCenter((Node)content);
        StackPane containerRight = new StackPane();
        containerRight.setAlignment(Pos.BOTTOM_LEFT);
        this.imageCardRight = LogEntry.createCardImage(imageSetSource);
        if (imageSetSource == null) {
            this.imageCardRight.setImage(null);
        }
        if (isSelfSource) {
            this.imageCardRight.setOpacity(0.75);
        }
        containerRight.getChildren().add((Object)this.imageCardRight);
        borderPane.setRight((Node)containerRight);
        if (abilityDescription != null || hasCost) {
            String stringIconLeft = !hasCost ? "\ud83d\uddf2" : (!isGuard ? "\ud83d\udcb0" : "\ud83d\udee1");
            Text textIcon = new Text(stringIconLeft);
            if (abilityIsConst) {
                this.buttonSourceAbility = new ToggleButton("\ud83d\udd17");
                this.buttonSourceAbility.setFont(Font.font((String)"file:fonts/Symbola-12.ttf", (double)14.0));
                this.buttonSourceAbility.setMinSize(24.0, 24.0);
                this.buttonSourceAbility.setMaxSize(24.0, 24.0);
                this.buttonSourceAbility.setPadding(Insets.EMPTY);
                this.buttonSourceAbility.setFocusTraversable(false);
                StackPane.setMargin((Node)this.buttonSourceAbility, (Insets)new Insets(0.0, 0.0, 12.0, 5.0));
                StackPane.setAlignment((Node)this.buttonSourceAbility, (Pos)Pos.BOTTOM_LEFT);
                StackPane containerSourceAbility = LogEntry.createCardAbilityDescription(abilityDescription);
                Image refImageLeft = this.imageCardLeft.getImage();
                this.buttonSourceAbility.setOnAction(e -> {
                    boolean isSelected = this.buttonSourceAbility.isSelected();
                    borderPane.setCenter((Node)(isSelected ? containerSourceAbility : content));
                    containerRight.setVisible(!isSelected);
                    containerRight.setManaged(!isSelected);
                    this.imageCardLeft.setImage(isSelected ? this.imageCardRight.getImage() : refImageLeft);
                    this.imageCardLeft.setOnMouseEntered(e2 -> UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(isSelected ? imageSetSource : imageSet));
                    textIcon.setText(isSelected ? this.buttonSourceAbility.getText() : stringIconLeft);
                });
                this.getChildren().add((Object)this.buttonSourceAbility);
            }
            textIcon.setFont(Font.font((String)"file:fonts/Symbola-12.ttf", (double)72.0));
            textIcon.setFill((Paint)Color.KHAKI);
            textIcon.setMouseTransparent(true);
            StackPane.setAlignment((Node)textIcon, (Pos)Pos.CENTER_LEFT);
            StackPane.setMargin((Node)textIcon, (Insets)new Insets(0.0, 0.0, imageSet != null ? 0.0 : 15.0, -10.0));
            this.getChildren().add((Object)textIcon);
            if (hasCost) {
                this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)0, (int)0, (int)128, (double)0.2), null, null)}));
            }
            StackPane.setMargin((Node)borderPane, (Insets)new Insets(0.0, 0.0, 0.0, 35.0));
        }
        this.getChildren().add((Object)borderPane);
    }

    public HBox getCustomContent() {
        return this.contentCustom;
    }

    public void addText(String s) {
        this.addText(s, Color.WHITE);
    }

    public void addText(String s, Color color) {
        this.addText(s, color, 21);
    }

    public void addText(String s, Color color, int size) {
        Text text = new Text(s);
        text.setFont(Font.font((String)"file:fonts/Symbola-12.ttf", (FontWeight)FontWeight.BOLD, (double)size));
        text.setFill((Paint)color);
        this.contentCustom.getChildren().add((Object)text);
    }

    @Override
    public void dispose() {
        if (this.buttonSourceAbility != null) {
            this.buttonSourceAbility.setOnAction(null);
        }
        this.imageCardLeft.setImage(null);
        this.imageCardLeft.setOnMouseEntered(null);
        this.imageCardRight.setImage(null);
        this.imageCardRight.setOnMouseEntered(null);
    }

    public static enum ArrowsDirection {
        LEFT,
        RIGHT,
        NONE;

    }
}

