/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import open.batoru.ImageCache;
import open.batoru.core.Game;
import open.batoru.data.ability.events.EventCoin;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.parsers.LanguageParser;

public class LogEntryCoin
extends LogEntry {
    public LogEntryCoin(EventCoin event) {
        this.setAlignment(Pos.CENTER_LEFT);
        StackPane backgrounds = new StackPane();
        backgrounds.getChildren().add((Object)LogEntry.createGradientBackground(true, Game.getCurrentGame().getPlayerRole() == event.getPlayer()));
        backgrounds.getChildren().add((Object)LogEntry.createGradientBackground(false, event.getGainedCoins() > 0));
        this.getChildren().add((Object)backgrounds);
        String username = Game.getCurrentGame().getRoom().getPlayerData(event.getPlayer()).getPlayerName();
        int coins = event.getGainedCoins();
        Text text = new Text(username + " " + LanguageParser.getString(coins > 0 ? "UI_GAME_LOG_COIN_GAIN" : "UI_GAME_LOG_COIN_PAY"));
        text.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)12.0));
        text.setFill((Paint)Color.KHAKI);
        HBox containerIcons = new HBox();
        containerIcons.setPadding(new Insets(5.0));
        containerIcons.setAlignment(Pos.CENTER_LEFT);
        containerIcons.setSpacing(5.0);
        containerIcons.getChildren().add((Object)text);
        for (int i = 0; i < Math.abs(coins); ++i) {
            ImageView icon = new ImageView(ImageCache.INSTANCE.getImageIcon("coin"));
            containerIcons.getChildren().add((Object)icon);
        }
        this.getChildren().add((Object)containerIcons);
        if (event.getSourceCost() != null) {
            this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)0, (int)0, (int)128, (double)0.2), null, null)}));
        }
    }
}

