/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.GameConst;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.parsers.LanguageParser;

public class LogEntryTarget
extends LogEntry
implements Disposable {
    private final ImageView imageCard;

    public LogEntryTarget(boolean targetIsOwnCard, String targetImageSet, String targetCardName, GameConst.CardLocation targetLocation, Boolean sourceIsOwnCard, Game.GamePlayerRole sourceTargetRole) {
        StackPane backgrounds = new StackPane();
        backgrounds.getChildren().add((Object)LogEntry.createGradientBackground(true, targetIsOwnCard));
        if (sourceIsOwnCard != null) {
            backgrounds.getChildren().add((Object)LogEntry.createGradientBackground(false, sourceIsOwnCard));
        }
        backgrounds.setOpacity(0.5);
        this.getChildren().add((Object)backgrounds);
        HBox content = new HBox();
        content.setPadding(new Insets(5.0));
        content.setAlignment(Pos.CENTER_LEFT);
        content.setSpacing(5.0);
        Text textIconTarget = new Text("\ud83c\udfaf");
        textIconTarget.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)28.0));
        textIconTarget.setFill((Paint)(sourceTargetRole != Game.getCurrentGame().getPlayerRole() ? Color.RED : Color.LIGHTGREEN));
        Text textIconLocation = new Text(GameConst.CardLocation.getIconByLocation(targetLocation));
        textIconLocation.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)14.0));
        textIconLocation.setFill((Paint)Color.KHAKI);
        Text textCardName = new Text(targetCardName);
        textCardName.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)10.0));
        textCardName.setFill((Paint)Color.WHITE);
        textCardName.setWrappingWidth(180.0);
        this.imageCard = LogEntry.createCardImage(targetImageSet);
        this.imageCard.setFitWidth(this.imageCard.getFitWidth() * 0.5);
        this.imageCard.setFitHeight(this.imageCard.getFitHeight() * 0.5);
        content.getChildren().addAll((Object[])new Node[]{textIconTarget, textIconLocation, this.imageCard, textCardName});
        StackPane.setAlignment((Node)content, (Pos)Pos.CENTER_LEFT);
        this.getChildren().add((Object)content);
    }

    @Override
    public void dispose() {
        this.imageCard.setImage(null);
        this.imageCard.setOnMouseEntered(null);
    }
}

