/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log;

import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.effect.BlendMode;
import javafx.scene.image.ImageView;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import open.batoru.ImageCache;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.CardConst;
import open.batoru.data.CardLoader;
import open.batoru.game.overlay.log.events.LogEvent;
import open.batoru.ui.UI;
import open.batoru.ui.UtilDispose;

public class OverlayGameLogExcludedCardsTracker
extends StackPane {
    private final ExcludedCardsBox boxTop = new ExcludedCardsBox(true);
    private final ExcludedCardsBox boxBottom = new ExcludedCardsBox(false);

    public OverlayGameLogExcludedCardsTracker() {
        this.setMinWidth(26.0);
        this.setMaxWidth(26.0);
        StackPane.setAlignment((Node)this.boxTop, (Pos)Pos.TOP_CENTER);
        StackPane.setMargin((Node)this.boxTop, (Insets)new Insets(40.0, 0.0, 0.0, 0.0));
        StackPane.setAlignment((Node)this.boxBottom, (Pos)Pos.BOTTOM_CENTER);
        StackPane.setMargin((Node)this.boxBottom, (Insets)new Insets(0.0, 0.0, 40.0, 0.0));
        this.getChildren().addAll((Object[])new Node[]{this.boxTop, this.boxBottom});
        UtilDispose.TEMP.attachChildDisposeListener((Node)this.boxTop);
        UtilDispose.TEMP.attachChildDisposeListener((Node)this.boxBottom);
    }

    public void addExcludedCard(CardIndex cardIndex, LogEvent sourceLogEvent) {
        ExcludedCardsBox box = CardIndex.getOriginalOwner(cardIndex.getId()) != Game.getCurrentGame().getPlayerRole() ? this.boxTop : this.boxBottom;
        box.addCardImage(cardIndex.getImageSet(), sourceLogEvent);
        this.setVisible(true);
        this.setManaged(true);
    }

    private static class ExcludedCardsBox
    extends VBox
    implements Disposable {
        private final boolean isTop;

        public ExcludedCardsBox(boolean isTop) {
            this.isTop = isTop;
            this.setVisible(false);
            this.setManaged(false);
            this.setAlignment(Pos.CENTER);
            this.setSpacing(5.0);
            ImageView icon = new ImageView(ImageCache.INSTANCE.getImage(ImageCache.getBorderIconTexturePath(TargetFilter.TargetHint.EXCLUDE)));
            icon.setFitWidth(24.0);
            icon.setFitHeight(24.0);
            icon.setBlendMode(BlendMode.SCREEN);
            this.getChildren().add((Object)icon);
            this.setMaxHeight(24.0);
        }

        public void addCardImage(String imageSet, LogEvent sourceLogEvent) {
            if (imageSet == null) {
                return;
            }
            ImageView image = new ImageView(ImageCache.INSTANCE.getCardImage(imageSet));
            image.setFitWidth(21.0);
            image.setFitHeight(29.0);
            if (!CardConst.CardType.isCardInHorizontalOrientation(CardLoader.getCardByImageSet(imageSet).getType())) {
                this.setMaxHeight(this.getMaxHeight() + image.getFitHeight() + 5.0);
            } else {
                image.setRotate(90.0);
                this.setMaxHeight(this.getMaxHeight() + image.getFitWidth() + 5.0);
            }
            image.setCursor(Cursor.HAND);
            image.setOnMouseEntered(e -> UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(imageSet));
            image.setOnMouseClicked(e -> UI.getTabGame().getFieldSceneOverlay().getGameLog().scrollTo(sourceLogEvent));
            if (this.isTop) {
                this.getChildren().add((Object)image);
            } else {
                this.getChildren().addFirst((Object)image);
            }
            this.setVisible(true);
            this.setManaged(true);
        }

        @Override
        public void dispose() {
            for (Node node : this.getChildren()) {
                if (!(node instanceof ImageView)) continue;
                ImageView imageView = (ImageView)node;
                imageView.setImage(null);
                node.setOnMouseEntered(null);
                node.setOnMouseClicked(null);
            }
        }
    }
}

