/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log;

import javafx.collections.ObservableList;
import javafx.geometry.Pos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Border;
import javafx.scene.layout.BorderStroke;
import javafx.scene.layout.BorderStrokeStyle;
import javafx.scene.layout.BorderWidths;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import open.batoru.ImageCache;
import open.batoru.core.Disposable;
import open.batoru.data.Card;
import open.batoru.data.CardLoader;
import open.batoru.game.overlay.log.events.LogEvent;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UI;

public class OverlayGameLogLifeClothTracker
extends ScrollPane {
    private final HBox content = new HBox();
    private int currentLC;
    private final boolean isTop;

    public OverlayGameLogLifeClothTracker(boolean isTop) {
        this.isTop = isTop;
        this.content.setAlignment(Pos.CENTER);
        this.content.setSpacing(2.0);
        this.setContent((Node)this.content);
        this.setFitToWidth(true);
        this.setFitToHeight(true);
        this.setStyle("-fx-background: transparent; -fx-background-color: transparent;");
        this.content.setMinHeight(30.0);
        this.content.setMaxHeight(this.getMinHeight());
        for (int i = 0; i < 7; ++i) {
            LifeClothTrackerBox box = new LifeClothTrackerBox();
            this.content.getChildren().add((Object)box);
        }
        if (!isTop) {
            this.currentLC = this.content.getChildren().size() - 1;
        }
    }

    public LifeClothTrackerBox moveNext(String imageSet, boolean isCrushed, LogEvent sourceLogEvent) {
        int n;
        if (this.currentLC < 0 || this.currentLC >= this.content.getChildren().size()) {
            return null;
        }
        ObservableList observableList = this.content.getChildren();
        if (this.isTop) {
            int n2 = this.currentLC;
            n = n2;
            this.currentLC = n2 + 1;
        } else {
            int n3 = this.currentLC;
            n = n3;
            this.currentLC = n3 - 1;
        }
        LifeClothTrackerBox box = (LifeClothTrackerBox)observableList.get(n);
        box.move(imageSet, isCrushed, sourceLogEvent);
        return box;
    }

    public void healNext(LogEvent sourceLogEvent) {
        LifeClothTrackerBox box = new LifeClothTrackerBox(sourceLogEvent);
        box.markAsHealed();
        this.content.getChildren().add(this.isTop ? this.currentLC : this.currentLC + 1, (Object)box);
        if (this.content.getChildren().size() == 11) {
            this.setMinViewportHeight(40.0);
        } else if (this.content.getChildren().size() > 10) {
            this.layout();
            this.setHvalue(this.isTop ? 1.0 : 0.0);
        }
        if (!this.isTop) {
            ++this.currentLC;
        }
    }

    public static class LifeClothTrackerBox
    extends StackPane
    implements Disposable {
        private static final Background BACKGROUND = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.SILVER, null, null)});
        private static final Border BORDER = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.rgb((int)60, (int)60, (int)60), BorderStrokeStyle.SOLID, null, new BorderWidths(2.0))});
        private static final Background BACKGROUND_GREEN = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.LIGHTGREEN, null, null)});
        private static final Border BORDER_GREEN = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.GREEN, BorderStrokeStyle.SOLID, null, new BorderWidths(2.0))});
        private static final Background BACKGROUND_RED = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.PINK, null, null)});
        private static final Border BORDER_RED = new Border(new BorderStroke[]{new BorderStroke((Paint)Color.RED, BorderStrokeStyle.SOLID, null, new BorderWidths(2.0))});
        private static final Background BACKGROUND_FAIL = new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.GREY, null, null)});
        private final Text text;
        private ImageView imageLBIcon;
        private ImageView imageCard;

        public LifeClothTrackerBox() {
            this(null);
        }

        public LifeClothTrackerBox(LogEvent sourceLogEvent) {
            this.setMinSize(30.0, 30.0);
            this.setMaxSize(30.0, 30.0);
            this.setBackground(BACKGROUND);
            this.setBorder(BORDER);
            if (sourceLogEvent != null) {
                this.setOnMouseClicked(e -> UI.getTabGame().getFieldSceneOverlay().getGameLog().scrollTo(sourceLogEvent));
            }
            this.text = new Text("?");
            this.text.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)16.0));
            this.text.setFill(((BorderStroke)BORDER.getStrokes().getFirst()).getTopStroke());
            this.text.setMouseTransparent(true);
            this.getChildren().add((Object)this.text);
        }

        void markAsHealed() {
            this.setBorder(BORDER_GREEN);
            this.setCursor(Cursor.HAND);
        }

        public void disableLBIcon() {
            if (this.imageLBIcon == null) {
                return;
            }
            this.imageLBIcon.setOpacity(0.5);
        }

        void move(String imageSet, boolean isCrushed, LogEvent sourceLogEvent) {
            if (isCrushed) {
                this.getChildren().remove((Object)this.text);
            } else {
                this.text.setText("\u2716");
            }
            if (imageSet != null) {
                Card card = CardLoader.getCardByImageSet(imageSet);
                this.imageCard = new ImageView(ImageCache.INSTANCE.getCardImage(imageSet));
                this.imageCard.setPreserveRatio(true);
                this.imageCard.setFitHeight(26.0);
                this.imageCard.setOpacity(0.5);
                if (isCrushed) {
                    this.imageCard.setOnMouseEntered(e -> this.imageCard.setOpacity(1.0));
                    this.imageCard.setOnMouseExited(e -> this.imageCard.setOpacity(0.5));
                }
                this.getChildren().add((Object)this.imageCard);
                if (card.hasLifeBurst()) {
                    this.imageLBIcon = new ImageView(ImageCache.INSTANCE.getImageIcon("lifeburst"));
                    this.imageLBIcon.setMouseTransparent(true);
                    this.getChildren().add((Object)this.imageLBIcon);
                    if (isCrushed) {
                        this.setBackground(BACKGROUND_GREEN);
                        this.setBorder(BORDER_GREEN);
                    } else {
                        this.disableLBIcon();
                    }
                } else if (isCrushed) {
                    this.setBackground(BACKGROUND_RED);
                    this.setBorder(BORDER_RED);
                }
            }
            if (!isCrushed) {
                this.setBackground(BACKGROUND_FAIL);
                this.text.toFront();
            }
            this.setCursor(Cursor.HAND);
            if (imageSet != null) {
                this.setOnMouseEntered(e -> UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(imageSet));
            }
            this.setOnMouseClicked(e -> UI.getTabGame().getFieldSceneOverlay().getGameLog().scrollTo(sourceLogEvent));
        }

        @Override
        public void dispose() {
            this.setOnMouseEntered(null);
            this.setOnMouseClicked(null);
            if (this.imageCard != null) {
                this.imageCard.setImage(null);
                this.imageCard.setOnMouseEntered(null);
                this.imageCard.setOnMouseExited(null);
            }
        }
    }
}

