/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log.events;

import open.batoru.catalog.description.DescriptionParser;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.events.EventAbilityGain;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.game.overlay.log.LogEntryAbility;
import open.batoru.game.overlay.log.events.LogEvent;
import open.batoru.parsers.LanguageParser;

public class LogEventAbilityLost
extends LogEvent {
    private final boolean isOwnCard;
    private final String imageSet;
    private final String cardName;
    private final String abilityDescription;
    private final String abilitySourceImageSet;
    private final String abilitySourceDescription;

    public LogEventAbilityLost(EventAbilityGain event) {
        CardIndex cardIndex = event.getCaller().getSourceCardIndex();
        this.isOwnCard = CardIndex.isOwnCard(cardIndex);
        this.imageSet = cardIndex.getImageSet();
        this.cardName = cardIndex.getCardReference().getName();
        StringBuilder header = new StringBuilder();
        DescriptionParser.appendCardAttachedAbilityHeader(header, cardIndex, event.getGainedAbility().getSourceAttachAbility());
        this.abilityDescription = String.valueOf(header) + DescriptionParser.getAbilityDescription(event.getGainedAbility());
        this.abilitySourceImageSet = event.getSourceAbility().getSourceCardIndex().getImageSet();
        this.abilitySourceDescription = DescriptionParser.getAbilityDescription(Ability.getRootSourceAttachAbility(event.getSourceAbility()));
    }

    @Override
    public LogEntry createNewLogEntry() {
        return new LogEntryAbility(this.isOwnCard, this.imageSet, this.cardName, this.abilitySourceImageSet, this.abilityDescription, this.abilitySourceDescription, "\u2796 " + LanguageParser.getString("UI_GAME_LOG_ABILITY_LOST") + ":");
    }
}

