/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log.events;

import javafx.scene.paint.Color;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.game.overlay.log.LogEntryCard;
import open.batoru.game.overlay.log.events.LogEvent;
import open.batoru.parsers.LanguageParser;

public class LogEventAttackSIGNI
extends LogEvent {
    private final boolean isOwnCard;
    private final String imageSet;
    private final String cardName;
    private final double power;
    private boolean isOwnCardOP;
    private String imageSetOP;
    private double powerOP;

    public LogEventAttackSIGNI(CardIndex cardIndex) {
        this(cardIndex, null);
    }

    public LogEventAttackSIGNI(CardIndex cardIndex, CardIndex cardIndexOP) {
        this.isOwnCard = CardIndex.isOwnCard(cardIndex);
        this.imageSet = cardIndex.getImageSet();
        this.cardName = cardIndex.getCardReference().getName();
        this.power = cardIndex.getIndexedInstance().getPower().getValue();
        if (cardIndexOP != null) {
            this.isOwnCardOP = CardIndex.isOwnCard(cardIndexOP);
            this.imageSetOP = cardIndexOP.getImageSet();
            this.powerOP = cardIndexOP.getIndexedInstance().getPower().getValue();
        }
    }

    @Override
    public LogEntry createNewLogEntry() {
        LogEntryCard entry = new LogEntryCard(this.isOwnCard, this.imageSet, this.cardName, this.isOwnCardOP, this.imageSetOP, LanguageParser.getString("UI_GAME_LOG_CARD_BATTLE"), LogEntryCard.ArrowsDirection.RIGHT);
        entry.addText("\u2694");
        double powerOP = this.imageSetOP != null ? this.powerOP : 0.0;
        entry.addText(this.power != Double.POSITIVE_INFINITY ? String.valueOf((int)this.power) : "\u221e", this.power >= powerOP ? Color.KHAKI : Color.WHITE, 14);
        if (this.imageSetOP != null) {
            entry.addText(this.power != powerOP ? (this.power > powerOP ? ">" : "<") : "=");
            entry.addText(powerOP != Double.POSITIVE_INFINITY ? String.valueOf((int)powerOP) : "\u221e", powerOP >= this.power ? Color.KHAKI : Color.WHITE, 14);
        }
        return entry;
    }
}

