/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log.events;

import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.core.Disposable;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.ability.Ability;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.game.overlay.log.LogEntryAbility;
import open.batoru.game.overlay.log.events.LogEvent;
import open.batoru.parsers.LanguageParser;

public class LogEventEffectTrigger
extends LogEvent
implements Disposable {
    private Ability ability;
    private final boolean isOwnCard;
    private final String imageSet;
    private final String cardName;
    private final String abilityDescription;

    public LogEventEffectTrigger(Ability ability) {
        this.ability = ability;
        CardIndex cardIndex = ability.getSourceCardIndex();
        this.isOwnCard = CardIndex.isOwnCard(cardIndex);
        this.imageSet = cardIndex.getImageSet() != null ? cardIndex.getImageSet() : ability.getCachedSourceCardImageSet();
        this.cardName = cardIndex.getCardReference() != null ? cardIndex.getCardReference().getName() : ability.getCachedSourceCardName();
        this.abilityDescription = DescriptionParser.getAbilityDescription(ability);
    }

    @Override
    public LogEntry createNewLogEntry() {
        LogEntryAbility entry = new LogEntryAbility(this.isOwnCard, this.imageSet, this.cardName, this.abilityDescription, "\ud83d\udca1 " + LanguageParser.getString("UI_GAME_LOG_ABILITY_TRIGGER") + ":");
        entry.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.rgb((int)128, (int)128, (int)0, (double)0.2), null, null)}));
        return entry;
    }

    public Ability getAbility() {
        return this.ability;
    }

    @Override
    public void dispose() {
        super.dispose();
        this.ability = null;
    }
}

