/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log.events;

import open.batoru.catalog.description.DescriptionParser;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.CardConst;
import open.batoru.data.ability.Ability;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.game.overlay.log.LogEntryCard;
import open.batoru.game.overlay.log.events.LogEvent;
import open.batoru.parsers.LanguageParser;

public class LogEventFlip
extends LogEvent {
    private final boolean isOwnCard;
    private final String imageSet;
    private final String cardName;
    private final CardConst.CardFace cardFace;
    private boolean isOwnCardSource;
    private String imageSetSource;
    private boolean isSelfSource;
    private String abilityDescription;

    public LogEventFlip(CardIndex caller, CardIndex source, Ability sourceAbility, CardConst.CardFace cardFace) {
        this.isOwnCard = CardIndex.isOwnCard(caller);
        this.imageSet = caller.getImageSet();
        this.cardName = caller.getCardReference().getName();
        this.cardFace = cardFace;
        if (source != null) {
            this.isOwnCardSource = CardIndex.isOwnCard(source);
            this.imageSetSource = source.getImageSet();
            boolean bl = this.isSelfSource = caller == source;
        }
        if (sourceAbility != null) {
            this.abilityDescription = DescriptionParser.getAbilityDescription(sourceAbility);
        }
    }

    @Override
    public LogEntry createNewLogEntry() {
        return new LogEntryCard(this.isOwnCard, this.imageSet, this.cardName, this.isOwnCardSource, this.imageSetSource, this.isSelfSource, this.abilityDescription, false, false, false, LanguageParser.getString(this.cardFace == CardConst.CardFace.BACK ? "UI_GAME_LOG_CARD_FACEDOWN" : "UI_GAME_LOG_CARD_FACEUP"), LogEntryCard.ArrowsDirection.LEFT);
    }
}

