/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log.events;

import javafx.scene.paint.Color;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.ability.events.EventGrow;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.game.overlay.log.LogEntryCard;
import open.batoru.game.overlay.log.events.LogEvent;
import open.batoru.parsers.LanguageParser;

public class LogEventGrow
extends LogEvent {
    private final boolean isOwnCard;
    private final String imageSet;
    private final String cardName;
    private final GameConst.CardLocation location;
    private final int level;
    private final boolean isOwnCardSource;
    private final String imageSetSource;
    private final int levelSource;
    private String abilityDescription;

    public LogEventGrow(EventGrow event) {
        CardIndex cardIndexNew = event.getCaller().getSourceCardIndex();
        CardIndex cardIndexOld = event.getSource().getSourceCardIndex();
        this.isOwnCard = CardIndex.isOwnCard(cardIndexNew);
        this.imageSet = cardIndexNew.getImageSet();
        this.cardName = cardIndexNew.getCardReference().getName();
        this.location = cardIndexNew.getLocation();
        this.level = cardIndexNew.getIndexedInstance().getLevel().getValue();
        this.isOwnCardSource = CardIndex.isOwnCard(cardIndexOld);
        this.imageSetSource = cardIndexOld.getImageSet();
        this.levelSource = cardIndexOld.getIndexedInstance().getLevel().getValue();
        if (event.getSourceAbility() != null) {
            this.abilityDescription = DescriptionParser.getAbilityDescription(event.getSourceAbility());
        }
    }

    @Override
    public LogEntry createNewLogEntry() {
        LogEntryCard entry = new LogEntryCard(this.isOwnCard, this.imageSet, this.cardName, this.isOwnCardSource, this.imageSetSource, false, this.abilityDescription, false, false, false, LanguageParser.getString("UI_GAME_LOG_CARD_GROW") + " " + GameConst.CardLocation.getIconByLocation(this.location), LogEntryCard.ArrowsDirection.LEFT);
        entry.addText(String.valueOf(this.level), Color.KHAKI);
        entry.addText("\ud83e\udc2c");
        entry.addText(String.valueOf(this.levelSource));
        return entry;
    }
}

