/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log.events;

import open.batoru.catalog.description.DescriptionParser;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityConst;
import open.batoru.data.ability.ConstantAbility;
import open.batoru.data.ability.events.EventMove;
import open.batoru.data.ability.events.GameEvent;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.game.overlay.log.LogEntryCard;
import open.batoru.game.overlay.log.events.LogEvent;

public class LogEventMove
extends LogEvent {
    private boolean isOwnCard;
    private String imageSet;
    private String cardName;
    private boolean isOwnCardSource;
    private String imageSetSource;
    private boolean isSelfSource;
    private String abilityDescription;
    private boolean abilityIsConst;
    private boolean hasCost;
    private boolean isGuard;
    private final GameConst.CardLocation oldLocation;
    private final GameConst.CardLocation newLocation;
    private final AbilityConst.ActionDescription actionHint;

    public LogEventMove(EventMove event, AbilityConst.ActionDescription actionHint) {
        this(event, event.getMoveLocation(), actionHint);
    }

    public LogEventMove(GameEvent event, GameConst.CardLocation newLocation, AbilityConst.ActionDescription actionHint) {
        this(event, event.getCaller().getLocation(), newLocation, actionHint);
    }

    public LogEventMove(GameEvent event, GameConst.CardLocation oldLocation, GameConst.CardLocation newLocation, AbilityConst.ActionDescription actionHint) {
        Ability sourceAbility;
        CardIndex caller = event.getCallerCardIndex();
        CardIndex source = event.getSourceCardIndex();
        if (caller != null && caller.getCardReference() != null) {
            this.isOwnCard = CardIndex.isOwnCard(caller);
            this.imageSet = caller.getImageSet();
            this.cardName = caller.getCardReference().getName();
        }
        if (source != null) {
            this.isOwnCardSource = CardIndex.isOwnCard(source);
            this.imageSetSource = source.getImageSet();
            boolean bl = this.isSelfSource = caller == source;
        }
        if ((sourceAbility = event.getSourceAbility()) != null) {
            this.abilityDescription = DescriptionParser.getAbilityDescription(sourceAbility);
            this.abilityIsConst = sourceAbility instanceof ConstantAbility;
        }
        if (event.getSourceCost() != null) {
            this.hasCost = true;
            this.isGuard = Game.getCurrentGame().getGameRules().isGuardStep();
        }
        this.oldLocation = oldLocation;
        this.newLocation = newLocation;
        this.actionHint = actionHint;
    }

    @Override
    public LogEntry createNewLogEntry() {
        LogEntryCard entry = new LogEntryCard(this.isOwnCard, this.imageSet, this.cardName, this.isOwnCardSource, this.imageSetSource, this.isSelfSource, this.abilityDescription, this.abilityIsConst, this.hasCost, this.isGuard, this.actionHint.getActionDescription(), LogEntryCard.ArrowsDirection.LEFT);
        entry.addText(GameConst.CardLocation.getIconByLocation(this.oldLocation));
        entry.addText("\u279e");
        entry.addText(GameConst.CardLocation.getIconByLocation(this.newLocation));
        return entry;
    }
}

