/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log.events;

import javafx.scene.paint.Color;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.ConstantAbility;
import open.batoru.data.ability.events.EventPowerChanged;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.game.overlay.log.LogEntryCard;
import open.batoru.game.overlay.log.events.LogEvent;
import open.batoru.parsers.LanguageParser;

public class LogEventPowerChanged
extends LogEvent {
    private final boolean isOwnCard;
    private final String imageSet;
    private final String cardName;
    private boolean isOwnCardSource;
    private String imageSetSource;
    private boolean isSelfSource;
    private String abilityDescription;
    private boolean abilityIsConst;
    private boolean hasCost;
    private boolean isGuard;
    private final double oldValue;
    private final double newValue;

    public LogEventPowerChanged(EventPowerChanged event, double oldValue) {
        Ability sourceAbility;
        CardIndex cardIndex = event.getCaller().getSourceCardIndex();
        CardIndex source = event.getSourceCardIndex();
        this.isOwnCard = CardIndex.isOwnCard(cardIndex);
        this.imageSet = cardIndex.getImageSet();
        this.cardName = cardIndex.getCardReference().getName();
        if (source != null) {
            this.isOwnCardSource = CardIndex.isOwnCard(source);
            this.imageSetSource = source.getImageSet();
            boolean bl = this.isSelfSource = cardIndex == source;
        }
        if ((sourceAbility = event.getSourceAbility()) != null) {
            this.abilityDescription = DescriptionParser.getAbilityDescription(sourceAbility);
            this.abilityIsConst = sourceAbility instanceof ConstantAbility;
        }
        if (event.getSourceCost() != null) {
            this.hasCost = true;
            this.isGuard = Game.getCurrentGame().getGameRules().isGuardStep();
        }
        this.oldValue = oldValue;
        this.newValue = event.getNewValue();
    }

    @Override
    public LogEntry createNewLogEntry() {
        LogEntryCard entry = new LogEntryCard(this.isOwnCard, this.imageSet, this.cardName, this.isOwnCardSource, this.imageSetSource, this.isSelfSource, this.abilityDescription, this.abilityIsConst, this.hasCost, this.isGuard, LanguageParser.getString("UI_GAME_LOG_CARD_POWER"), LogEntryCard.ArrowsDirection.LEFT);
        entry.addText(this.oldValue != Double.POSITIVE_INFINITY ? String.valueOf((int)this.oldValue) : "\u221e", Color.WHITE, 14);
        entry.addText("\u279e");
        entry.addText(this.newValue != Double.POSITIVE_INFINITY ? String.valueOf((int)this.newValue) : "\u221e", this.newValue > 0.0 ? Color.WHITE : Color.KHAKI, 14);
        return entry;
    }
}

