/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.log.events;

import open.batoru.catalog.description.DescriptionParser;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.ConstantAbility;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.game.overlay.log.LogEntry;
import open.batoru.game.overlay.log.LogEntryCard;
import open.batoru.game.overlay.log.events.LogEvent;
import open.batoru.parsers.LanguageParser;

public class LogEventUp
extends LogEvent {
    private final boolean isOwnCard;
    private final String imageSet;
    private final String cardName;
    private boolean isOwnCardSource;
    private String imageSetSource;
    private boolean isSelfSource;
    private String abilityDescription;
    private boolean abilityIsConst;
    private boolean hasCost;
    private boolean isGuard;

    public LogEventUp(CardIndex caller, CardIndex source, Ability sourceAbility, AbilityCost sourceCost) {
        this.isOwnCard = CardIndex.isOwnCard(caller);
        this.imageSet = caller.getImageSet();
        this.cardName = caller.getCardReference().getName();
        if (source != null) {
            this.isOwnCardSource = CardIndex.isOwnCard(source);
            this.imageSetSource = source.getImageSet();
            boolean bl = this.isSelfSource = caller == source;
        }
        if (sourceAbility != null) {
            this.abilityDescription = DescriptionParser.getAbilityDescription(sourceAbility);
            this.abilityIsConst = sourceAbility instanceof ConstantAbility;
        }
        if (sourceCost != null) {
            this.hasCost = true;
            this.isGuard = Game.getCurrentGame().getGameRules().isGuardStep();
        }
    }

    @Override
    public LogEntry createNewLogEntry() {
        return new LogEntryCard(this.isOwnCard, this.imageSet, this.cardName, this.isOwnCardSource, this.imageSetSource, this.isSelfSource, this.abilityDescription, this.abilityIsConst, this.hasCost, this.isGuard, LanguageParser.getString("UI_GAME_LOG_CARD_UP"), LogEntryCard.ArrowsDirection.LEFT);
    }
}

