/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.window;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javafx.geometry.HPos;
import javafx.geometry.Insets;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.image.ImageView;
import javafx.scene.layout.FlowPane;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Rectangle;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import open.batoru.ImageCache;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.data.CardConst;
import open.batoru.data.CardDataImageSet;
import open.batoru.data.CardLoader;
import open.batoru.game.overlay.OverlayConst;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.FX;
import open.batoru.ui.UI;
import open.batoru.ui.UIConst;

public abstract class OverlayWindow
extends StackPane
implements Disposable {
    private static final Map<String, OverlayWindow> mapAddedWindows = new HashMap<String, OverlayWindow>();
    private WindowFrame frame;
    private String alias;
    private boolean isInformationWindow;
    private final VBox content = new VBox();
    private final FlowPane containerButtons = new FlowPane();
    private final Button buttonConfirm;
    private Text textDescription;

    public OverlayWindow(String title, String description) {
        this(title, description, "border", "border2");
    }

    public OverlayWindow(String title, String description, String borderImageTop, String borderImageBottom) {
        this.setMaxWidth(700.0);
        ImageView borderTop = new ImageView(ImageCache.INSTANCE.getImage("overlay/" + borderImageTop + ".png"));
        ImageView borderBottom = new ImageView(ImageCache.INSTANCE.getImage("overlay/" + borderImageBottom + ".png"));
        borderBottom.setRotate(180.0);
        VBox container = new VBox();
        container.setPadding(new Insets(25.0, 0.0, 7.0, 0.0));
        container.setAlignment(Pos.CENTER);
        container.setSpacing(10.0);
        container.setMaxWidth(660.0);
        container.setBackground(UIConst.Style.BACKGROUND_OVERLAY);
        container.setBorder(UIConst.Style.BORDER_OVERLAY);
        this.content.setAlignment(Pos.CENTER);
        this.content.setSpacing(10.0);
        if (title != null && !title.isEmpty()) {
            Text textTitle = new Text(title);
            textTitle.setTextAlignment(TextAlignment.CENTER);
            textTitle.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)16.0));
            textTitle.setFill((Paint)Color.KHAKI);
            textTitle.setWrappingWidth(660.0);
            container.getChildren().add((Object)textTitle);
        }
        if (description != null && !description.isEmpty()) {
            this.textDescription = new Text(description);
            this.textDescription.setTextAlignment(TextAlignment.CENTER);
            this.textDescription.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)12.0));
            this.textDescription.setFill((Paint)Color.WHITE);
            this.textDescription.setWrappingWidth(660.0);
            container.getChildren().add((Object)this.textDescription);
        }
        container.getChildren().add((Object)this.content);
        this.containerButtons.setAlignment(Pos.TOP_CENTER);
        this.containerButtons.setOrientation(Orientation.VERTICAL);
        this.containerButtons.setColumnHalignment(HPos.CENTER);
        this.containerButtons.setVgap(10.0);
        this.containerButtons.setHgap(10.0);
        this.containerButtons.setPrefHeight(0.0);
        this.buttonConfirm = OverlayWindow.createButton(OverlayConst.BUTTON_TEXT_CONFIRM);
        this.addWindowButton(this.buttonConfirm);
        container.getChildren().add((Object)this.containerButtons);
        StackPane.setMargin((Node)container, (Insets)new Insets(20.0, 0.0, 20.0, 0.0));
        StackPane.setAlignment((Node)borderTop, (Pos)Pos.TOP_CENTER);
        StackPane.setAlignment((Node)borderBottom, (Pos)Pos.BOTTOM_CENTER);
        this.getChildren().addAll((Object[])new Node[]{container, borderTop, borderBottom});
    }

    private void setFrame(WindowFrame frame) {
        this.frame = frame;
    }

    private WindowFrame getFrame() {
        return this.frame;
    }

    public void updateDescriptionText(String text) {
        if (this.textDescription != null) {
            this.textDescription.setText(text);
        }
    }

    @Override
    public void dispose() {
        if (this.frame != null) {
            this.frame.dispose();
        }
        for (Node node : this.containerButtons.getChildren()) {
            if (!(node instanceof Button)) continue;
            Button button = (Button)node;
            button.setOnAction(null);
        }
    }

    public final VBox getContentNode() {
        return this.content;
    }

    public final Button getConfirmButton() {
        return this.buttonConfirm;
    }

    public final void hideConfirmButton() {
        if (!this.buttonConfirm.isVisible()) {
            return;
        }
        this.containerButtons.setPrefHeight(this.containerButtons.getPrefHeight() - (this.buttonConfirm.getPrefHeight() + this.containerButtons.getVgap()));
        this.buttonConfirm.setVisible(false);
        this.buttonConfirm.setManaged(false);
    }

    public void addWindowButton(Button button) {
        this.containerButtons.setPrefHeight(this.containerButtons.getPrefHeight() + button.getPrefHeight() + this.containerButtons.getVgap());
        this.containerButtons.getChildren().add((Object)button);
    }

    @Deprecated
    public void addTextToButtonsContainer(Text text) {
        this.containerButtons.setPrefHeight(this.containerButtons.getPrefHeight() + 28.0 + this.containerButtons.getVgap());
        this.containerButtons.getChildren().addFirst((Object)text);
    }

    public void forceFakeChoice(List<String> choices) {
        this.buttonConfirm.fire();
    }

    public void setAlias(String alias) {
        this.alias = alias;
    }

    public String getAlias() {
        return this.alias != null ? this.alias : this.toString();
    }

    public void setIsInformationWindow() {
        this.isInformationWindow = true;
    }

    public void toggleVisibility() {
        this.setOpacity(this.getOpacity() == 1.0 ? 0.2 : 1.0);
        this.setMouseTransparent(!this.isMouseTransparent());
    }

    public static ImageView createCardImage(CardIndex cardIndex) {
        return OverlayWindow.createCardImage(cardIndex, true);
    }

    public static ImageView createCardImage(CardIndex cardIndex, boolean shouldRotate) {
        String imageSet = cardIndex.getImageSet();
        ImageView cardImage = OverlayWindow.createCardImage(imageSet);
        if (cardIndex.getIndexedInstance() != null) {
            cardImage.setImage(cardIndex.getSourceCard3D().getCardMeshFace().getTexture());
        }
        if (shouldRotate && (cardIndex.getCardReference() != null && CardConst.CardType.isCardInHorizontalOrientation(cardIndex.getCardReference().getType()) || CardLoader.getImageSetMaskType(imageSet) == CardDataImageSet.MaskType.VERTICAL)) {
            cardImage.setRotate(90.0);
        }
        cardImage.setOnMouseEntered(e -> {
            if (cardIndex.getIndexedInstance() != null) {
                UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(cardIndex);
            } else if (imageSet != null) {
                UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(imageSet);
            }
        });
        return cardImage;
    }

    public static ImageView createCardImage(String imageSet) {
        ImageView cardImage = new ImageView(ImageCache.INSTANCE.getCardImage(imageSet));
        cardImage.setFitWidth(63.0);
        cardImage.setFitHeight(87.0);
        Rectangle clip = new Rectangle(63.0, 87.0);
        clip.setArcWidth(9.0);
        clip.setArcHeight(9.0);
        cardImage.setClip((Node)clip);
        cardImage.setOnMouseEntered(e -> UI.getTabGame().getFieldSceneOverlay().getCardPreview().update(imageSet));
        return cardImage;
    }

    public static Text createText() {
        Text text = new Text();
        text.setFill((Paint)Color.WHITE);
        return text;
    }

    public static Text createText(Color color, int fontSize, String string) {
        Text text = new Text(string);
        text.setFill((Paint)color);
        text.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)fontSize));
        return text;
    }

    public static Button createButton(String text) {
        Button button = new Button(text);
        button.setMinWidth(200.0);
        button.setPrefHeight(28.0);
        button.getStyleClass().add((Object)"button_game_ui");
        return button;
    }

    public static void addToFieldOverlay(OverlayWindow window) {
        if (mapAddedWindows.containsKey(window.getAlias()) || Game.getCurrentGame().getGameState() == Game.GameState.POST_GAME) {
            return;
        }
        mapAddedWindows.put(window.getAlias(), window);
        FX.run(() -> {
            if (window.getFrame() == null) {
                window.setFrame(new WindowFrame(window));
            }
            UI.getTabGame().getFieldSceneOverlay().getWindowsNode().getChildren().add((Object)window.getFrame());
        });
        if (Game.getCurrentGame().getFakeReceiver() != null && !window.isInformationWindow) {
            Game.getCurrentGame().getFakeReceiver().forceConfirmWindow(window);
        }
    }

    public static void removeFromFieldOverlay(OverlayWindow window) {
        if (mapAddedWindows.remove(window.getAlias()) != null) {
            FX.run(() -> UI.getTabGame().getFieldSceneOverlay().getWindowsNode().getChildren().remove((Object)window.getFrame()));
        } else {
            FX.run(window::dispose);
        }
    }

    public static void hideWindow(OverlayWindow window) {
        if (window.getFrame() == null) {
            return;
        }
        window.getFrame().setVisible(false);
        window.getFrame().setManaged(false);
    }

    public static void showWindow(OverlayWindow window) {
        if (window.getFrame() == null) {
            return;
        }
        window.getFrame().setVisible(true);
        window.getFrame().setManaged(true);
    }

    public static boolean isAddedToFieldOverlay(String alias) {
        return mapAddedWindows.containsKey(alias);
    }

    public static void clearWindows() {
        mapAddedWindows.clear();
    }

    private static class WindowFrame
    extends StackPane
    implements Disposable {
        private final Button buttonToggleVisibility = new Button("\u2796");

        public WindowFrame(OverlayWindow window) {
            this.buttonToggleVisibility.setFont(Font.font((double)10.0));
            this.buttonToggleVisibility.setMinSize(25.0, 25.0);
            this.buttonToggleVisibility.setMaxSize(25.0, 25.0);
            this.buttonToggleVisibility.getStyleClass().add((Object)"button_game_ui");
            StackPane.setAlignment((Node)this.buttonToggleVisibility, (Pos)Pos.TOP_RIGHT);
            StackPane.setMargin((Node)this.buttonToggleVisibility, (Insets)new Insets(40.0, 30.0, 0.0, 0.0));
            this.buttonToggleVisibility.setOnAction(e -> window.toggleVisibility());
            this.setPickOnBounds(false);
            this.getChildren().addAll((Object[])new Node[]{window, this.buttonToggleVisibility});
        }

        @Override
        public void dispose() {
            this.buttonToggleVisibility.setOnAction(null);
        }
    }
}

