/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.window;

import java.util.List;
import javafx.scene.web.WebView;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.core.Game;
import open.batoru.data.ability.Ability;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.parsers.LanguageParser;

public class OverlayWindowAbilityInfo
extends OverlayWindow {
    public OverlayWindowAbilityInfo(List<Ability> listAbilities) {
        super(LanguageParser.getString("UI_GAME_WINDOW_ABILITY_TITLE_VIEW"), null);
        WebView descriptionWebView = new WebView();
        descriptionWebView.setContextMenuEnabled(false);
        descriptionWebView.getEngine().setJavaScriptEnabled(false);
        descriptionWebView.setMaxSize(400.0, 100.0);
        StringBuilder description = new StringBuilder();
        for (Ability ability : listAbilities) {
            description.append(Game.getCurrentGame().getPlayerRole() == ability.getSourceAttachAbility().getSourceCardIndex().getCurrentOwnerSafe() ? "@+|+" : "@-|-");
            description.append(LanguageParser.getString("CARD_TEXT_ABILITY_GAINED_BY")).append(" `").append(ability.getSourceAttachAbility().getSourceCardIndex().getCardReference() != null ? ability.getSourceAttachAbility().getSourceCardIndex().getCardReference().getName() : ability.getCachedSourceCardName()).append("`]@@@");
            description.append(DescriptionParser.getAbilityDescription(ability));
            description.append("@@");
        }
        descriptionWebView.getEngine().loadContent(DescriptionParser.DEFAULT.parseDescription(description.toString()));
        this.getConfirmButton().setText(LanguageParser.getString("UI_GAME_WINDOW_BUTTON_CLOSE"));
        this.getContentNode().getChildren().add((Object)descriptionWebView);
    }
}

