/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.window;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Orientation;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Separator;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.shape.Rectangle;
import open.batoru.ImageCache;
import open.batoru.Settings;
import open.batoru.core.gameplay.pickers.CardPicker;
import open.batoru.data.ability.AbilityConst;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.parsers.LanguageParser;

public class OverlayWindowCard
extends OverlayWindow {
    private final List<ImageView> listCardImages = new ArrayList<ImageView>();
    private boolean autoConfirm;
    private final int minPicks;
    private final int maxPicks;
    private final AbilityConst.ChoiceLogic choiceLogic;
    private int oldPickedCount;
    private final String description;
    private boolean showPickedCount = true;
    private String buttonTextContinue = LanguageParser.getString("UI_GAME_WINDOW_BUTTON_CONTINUE");
    private String buttonTextSkip = LanguageParser.getString("UI_GAME_WINDOW_BUTTON_SKIP");

    public OverlayWindowCard(String title, String description, int minPicks, int maxPicks) {
        this(title, description, minPicks, maxPicks, AbilityConst.ChoiceLogic.DEFAULT);
    }

    public OverlayWindowCard(String title, String description, int minPicks, int maxPicks, AbilityConst.ChoiceLogic choiceLogic) {
        super(title, (String)(maxPicks > minPicks && maxPicks != 100 ? "0 / " + maxPicks + "\n" : "") + (description != null ? description : ""));
        this.description = description;
        HBox boxCards = new HBox();
        boxCards.setAlignment(Pos.CENTER);
        boxCards.setSpacing(10.0);
        this.minPicks = minPicks;
        this.maxPicks = maxPicks;
        this.choiceLogic = choiceLogic;
        if (minPicks > 1) {
            int i;
            for (i = 0; i < minPicks; ++i) {
                boxCards.getChildren().add((Object)this.createOverlayCardImage());
            }
            if (maxPicks > minPicks && maxPicks != 100) {
                boxCards.getChildren().add((Object)new Separator(Orientation.VERTICAL));
                for (i = minPicks; i < maxPicks; ++i) {
                    boxCards.getChildren().add((Object)this.createOverlayCardImage());
                }
            }
        }
        this.getConfirmButton().setText(minPicks > 0 ? this.buttonTextContinue : this.buttonTextSkip);
        if (minPicks > 0) {
            this.getConfirmButton().setDisable(true);
        }
        this.getContentNode().getChildren().add((Object)boxCards);
    }

    public void setConfirmButtonText(String textContinue, String textSkip) {
        this.getConfirmButton().setText(this.getConfirmButton().getText().equals(this.buttonTextContinue) ? textContinue : textSkip);
        this.buttonTextContinue = textContinue;
        this.buttonTextSkip = textSkip;
    }

    private ImageView createOverlayCardImage() {
        ImageView imageCard = new ImageView(ImageCache.INSTANCE.getMainCardBackImage());
        imageCard.setFitWidth(44.099999999999994);
        imageCard.setFitHeight(60.9);
        Rectangle clip = new Rectangle(44.099999999999994, 60.9);
        clip.setArcWidth(6.3);
        clip.setArcHeight(6.3);
        imageCard.setClip((Node)clip);
        imageCard.setOpacity(0.75);
        this.listCardImages.add(imageCard);
        return imageCard;
    }

    public void setAutoConfirm(boolean set) {
        this.autoConfirm = Settings.INSTANCE.shouldAutoConfirmChosenCards() && set;
    }

    public void setShowPickedCount(boolean set) {
        this.showPickedCount = set;
        if (!this.showPickedCount) {
            this.updateDescriptionText(this.description);
        }
    }

    public void updatePickedCount(int newPickedCount) {
        this.updatePickedCount(newPickedCount, null);
    }

    public void updatePickedCount(int newPickedCount, CardPicker picker) {
        boolean isConditionValid;
        if (this.minPicks > 1) {
            if (newPickedCount >= this.oldPickedCount) {
                this.listCardImages.get(newPickedCount - 1).setOpacity(1.0);
            } else {
                this.listCardImages.get(this.oldPickedCount - 1).setOpacity(0.75);
            }
        }
        this.oldPickedCount = newPickedCount;
        boolean bl = isConditionValid = picker == null || picker.getCondition() == null || this.minPicks == 0 && newPickedCount == 0 || newPickedCount >= this.minPicks && picker.getCondition().isValid(picker.getPickedCardIndexList());
        if (this.minPicks == 0) {
            this.getConfirmButton().setText(newPickedCount > 0 ? this.buttonTextContinue : this.buttonTextSkip);
        }
        this.getConfirmButton().setDisable(!isConditionValid || (this.choiceLogic != AbilityConst.ChoiceLogic.BOOLEAN ? this.minPicks > 0 && newPickedCount < this.minPicks || newPickedCount > this.maxPicks : newPickedCount != this.minPicks && newPickedCount != this.maxPicks));
        if (this.autoConfirm && this.choiceLogic != AbilityConst.ChoiceLogic.BOOLEAN && newPickedCount >= this.minPicks && isConditionValid) {
            this.getConfirmButton().fire();
        }
        if (this.showPickedCount && this.maxPicks > this.minPicks && this.maxPicks != 100) {
            this.updateDescriptionText(newPickedCount + " / " + this.maxPicks + "\n" + (this.description != null ? this.description : ""));
        }
    }

    @Override
    public void forceFakeChoice(List<String> choices) {
        this.getConfirmButton().setDisable(false);
        super.forceFakeChoice(choices);
    }
}

