/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.window;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javafx.beans.value.ChangeListener;
import javafx.collections.FXCollections;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.ComboBox;
import javafx.scene.control.ScrollPane;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.text.Font;
import javafx.scene.text.FontWeight;
import javafx.scene.text.Text;
import open.batoru.core.Disposable;
import open.batoru.core.Game;
import open.batoru.core.gameplay.CardIndex;
import open.batoru.core.gameplay.GameConst;
import open.batoru.core.gameplay.pickers.CardPicker;
import open.batoru.core.gameplay.pickers.ConditionHandler;
import open.batoru.core.gameplay.pickers.PickValidator;
import open.batoru.core.gameplay.pickers.Picker;
import open.batoru.data.Card;
import open.batoru.data.CardData;
import open.batoru.data.CardDataType;
import open.batoru.data.ability.AbilityConst;
import open.batoru.game._3d.Card3D;
import open.batoru.game.overlay.OverlayConst;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UIConst;
import open.batoru.ui.UtilDispose;

public class OverlayWindowCardList
extends OverlayWindow {
    private final List<Card3D> listCards;
    private final List<Card3D> listPickedCards = new ArrayList<Card3D>();
    private final List<Card3D> listChangedPickedStateCards = new ArrayList<Card3D>();
    private PickValidator<Card3D> validator;
    private ConditionHandler<CardIndex> condition;
    private CardPicker picker;
    private int totalValidTargets;
    private final int minPicks;
    private final int maxPicks;
    private final AbilityConst.ChoiceLogic choiceLogic;
    private final HBox content = new HBox();
    private final HBox contentInfo;
    private ComboBox<String> boxSorting;
    private ChangeListener<String> listenerSortingValue;
    private boolean autoConfirm;
    private final String description;
    private boolean isLocked;

    public OverlayWindowCardList(String title, String description, List<Card3D> listCards, CardPicker picker, int minPicks) {
        this(title, description, listCards, picker, picker.getValidator(), picker.getCondition(), minPicks, picker.getMaxPicks(), AbilityConst.ChoiceLogic.DEFAULT);
    }

    public OverlayWindowCardList(String title, String description, List<Card3D> listCards) {
        this(title, description, listCards, null, null, null, 0, 0, AbilityConst.ChoiceLogic.DEFAULT);
    }

    public OverlayWindowCardList(String title, String description, List<Card3D> listCards, PickValidator<Card3D> validator, ConditionHandler<CardIndex> condition, int minPicks, int maxPicks) {
        this(title, description, listCards, null, validator, condition, minPicks, maxPicks, AbilityConst.ChoiceLogic.DEFAULT);
    }

    public OverlayWindowCardList(String title, String description, List<Card3D> listCards, CardPicker picker, PickValidator<Card3D> validator, ConditionHandler<CardIndex> condition, int minPicks, int maxPicks, AbilityConst.ChoiceLogic choiceLogic) {
        super(title, (String)((maxPicks > minPicks || maxPicks > 1) && maxPicks != 100 ? "0 / " + maxPicks + "\n" : "") + (description != null ? description : ""));
        this.description = description;
        this.picker = picker;
        this.validator = validator;
        this.condition = condition;
        this.minPicks = minPicks;
        this.maxPicks = maxPicks;
        this.choiceLogic = choiceLogic;
        ScrollPane contentScroll = new ScrollPane((Node)this.content);
        contentScroll.setStyle("-fx-background: black;");
        contentScroll.setPrefWidth(660.0);
        if (listCards.size() >= 10) {
            contentScroll.setPrefHeight(127.0);
        }
        this.getConfirmButton().setText(maxPicks > 0 ? (minPicks > 0 || picker != null ? OverlayConst.BUTTON_TEXT_CONFIRM : OverlayConst.BUTTON_TEXT_SKIP) : OverlayConst.BUTTON_TEXT_CLOSE);
        this.listCards = new ArrayList<Card3D>(listCards);
        this.contentInfo = new HBox();
        this.contentInfo.setAlignment(Pos.CENTER_LEFT);
        this.contentInfo.setPadding(new Insets(-5.0, 0.0, 0.0, 5.0));
        this.contentInfo.setSpacing(5.0);
        this.getContentNode().getChildren().addAll((Object[])new Node[]{contentScroll, this.contentInfo});
        this.populate();
    }

    public final void enableCardSorting() {
        if (this.boxSorting != null) {
            return;
        }
        ArrayList listOriginal = new ArrayList();
        this.content.getChildren().forEach(node -> listOriginal.add((CardEntry)node));
        this.boxSorting = new ComboBox(FXCollections.observableArrayList(Arrays.stream(SortingOperations.values()).map(SortingOperations::getLabel).toList()));
        this.boxSorting.getSelectionModel().selectFirst();
        this.listenerSortingValue = (ov, oldValue, newValue) -> this.sortCards((String)newValue, listOriginal);
        this.boxSorting.valueProperty().addListener(this.listenerSortingValue);
        this.contentInfo.getChildren().add(this.boxSorting);
    }

    private void sortCards(String value, List<CardEntry> listOriginal) {
        Comparator<CardEntry> comparator = SortingOperations.getSortingOperationByLabel(value).getComparator();
        this.content.getChildren().setAll(comparator != null ? listOriginal.stream().sorted(comparator).toList() : listOriginal);
        for (int i = 0; i < this.content.getChildren().size(); ++i) {
            ((CardEntry)this.content.getChildren().get(i)).setId(this.content.getChildren().size() - i);
        }
    }

    private void populate() {
        for (int i = this.listCards.size() - 1; i >= 0; --i) {
            boolean isValid;
            Card3D card3D = this.listCards.get(i);
            boolean bl = isValid = this.validator == null || this.validator.isPickValid(card3D);
            if (isValid) {
                ++this.totalValidTargets;
            }
            CardEntry entry = new CardEntry(i + 1, card3D);
            entry.setIsValid(isValid);
            this.content.getChildren().add((Object)entry);
        }
        this.updateConfirmButtonState();
    }

    public void updateList() {
        this.totalValidTargets = 0;
        this.content.getChildren().forEach(node -> {
            if (node instanceof CardEntry) {
                boolean isValid;
                CardEntry entry = (CardEntry)node;
                boolean bl = isValid = this.validator == null || this.validator.isPickValid(entry.getSourceCard3D());
                if (isValid) {
                    ++this.totalValidTargets;
                }
                entry.setIsValid(isValid);
            }
        });
        this.updateConfirmButtonState();
    }

    private void updateConfirmButtonState() {
        this.getConfirmButton().setDisable(this.minPicks > 0 && (this.totalValidTargets > 0 || this.condition != null));
    }

    public void setAutoConfirm(boolean set) {
        this.autoConfirm = set;
    }

    public void setLock(boolean lock) {
        this.isLocked = lock;
    }

    final List<Card3D> getCardList() {
        return this.listCards;
    }

    public Picker<Card3D> getPicker() {
        return this.picker;
    }

    public List<Card3D> getPickedList() {
        return this.listPickedCards;
    }

    public List<Card3D> getChangedPickedStateList() {
        return this.listChangedPickedStateCards;
    }

    public int getPickedCount() {
        return this.listPickedCards.size();
    }

    public HBox getContentInfoNode() {
        return this.contentInfo;
    }

    public List<CardIndex> getCachedPickedListCardIndexes() {
        return this.listPickedCards.stream().map(Card3D::getCardIndex).toList();
    }

    public int getTotalValidTargets() {
        return this.totalValidTargets;
    }

    public void updatePickedCount(int newPickedCount) {
        if (this.minPicks == 0) {
            this.getConfirmButton().setText(newPickedCount > 0 || this.picker != null ? OverlayConst.BUTTON_TEXT_CONFIRM : OverlayConst.BUTTON_TEXT_SKIP);
        }
        boolean isConditionValid = this.condition == null || this.minPicks == 0 && newPickedCount == 0 || this.condition.isValid(this.getCachedPickedListCardIndexes());
        this.getConfirmButton().setDisable(!isConditionValid || (this.choiceLogic != AbilityConst.ChoiceLogic.BOOLEAN ? this.minPicks > 0 && newPickedCount < this.minPicks || newPickedCount > this.maxPicks : newPickedCount != this.minPicks && newPickedCount != this.maxPicks));
        if (this.autoConfirm && this.choiceLogic != AbilityConst.ChoiceLogic.BOOLEAN && newPickedCount >= this.minPicks && isConditionValid) {
            this.getConfirmButton().fire();
        }
        if ((this.maxPicks > this.minPicks || this.maxPicks > 1) && this.maxPicks != 100) {
            this.updateDescriptionText(newPickedCount + " / " + this.maxPicks + "\n" + (this.description != null ? this.description : ""));
        }
    }

    @Override
    public void forceFakeChoice(List<String> choices) {
        if (this.picker != null || this.minPicks == 0 && this.maxPicks == 0 && this.validator == null) {
            return;
        }
        if (!choices.getFirst().equals(String.valueOf(0))) {
            for (String choice : choices) {
                CardIndex cardIndex = Game.getCurrentGame().getIndexRegistry().getIndex(Integer.parseInt(choice));
                this.listPickedCards.add(cardIndex.getSourceCard3D());
            }
        }
        this.getConfirmButton().setDisable(false);
        super.forceFakeChoice(choices);
    }

    @Override
    public void dispose() {
        super.dispose();
        UtilDispose.TEMP.attachChildDisposeListener((Node)this.content);
        this.content.getChildren().clear();
        UtilDispose.TEMP.detachChildDisposeListener((Node)this.content);
        if (this.boxSorting != null) {
            this.boxSorting.valueProperty().removeListener(this.listenerSortingValue);
            this.listenerSortingValue = null;
        }
        this.listCards.clear();
        this.listPickedCards.clear();
        this.listChangedPickedStateCards.clear();
        this.validator = null;
        this.condition = null;
        this.picker = null;
    }

    private static enum SortingOperations {
        NONE("UI_GAME_WINDOW_COMBOBOX_SORT_NONE", null),
        NAME("UI_GAME_WINDOW_COMBOBOX_SORT_NAME", SortingOperations.createComparator(cardObject -> cardObject::getName)),
        TYPE("UI_GAME_WINDOW_COMBOBOX_SORT_TYPE", SortingOperations.createComparator(card -> new CardDataType(card.getType())).thenComparing(SortingOperations.NAME.comparator)),
        COLOR("UI_GAME_WINDOW_COMBOBOX_SORT_COLOR", SortingOperations.createComparator(Card::getColor).thenComparing(SortingOperations.NAME.comparator)),
        SIGNI_CLASS("UI_GAME_WINDOW_COMBOBOX_SORT_CLASS", SortingOperations.createComparator(Card::getSIGNIClass).thenComparing(SortingOperations.NAME.comparator)),
        LIFE_BURST("UI_GAME_WINDOW_COMBOBOX_SORT_LIFEBURST", SortingOperations.createComparator(cardObject -> () -> !cardObject.hasLifeBurst()).thenComparing(SortingOperations.NAME.comparator));

        private final String label;
        private final Comparator<CardEntry> comparator;
        private static final Map<String, SortingOperations> mapLabels;

        private SortingOperations(String label, Comparator<CardEntry> comparator) {
            this.label = LanguageParser.getString("UI_GAME_WINDOW_COMBOBOX_SORT") + " " + LanguageParser.getString(label);
            this.comparator = comparator;
        }

        private String getLabel() {
            return this.label;
        }

        private Comparator<CardEntry> getComparator() {
            return this.comparator;
        }

        private static <T extends Comparable<? super T>> Comparator<CardEntry> createComparator(Function<Card, CardData<T>> handlerMod) {
            return Comparator.comparing(c -> {
                Card cardObject = c.getCardReference();
                return cardObject != null ? (Comparable)((CardData)handlerMod.apply(cardObject)).getPrimaryValue() : null;
            }, Comparator.nullsLast(Comparator.naturalOrder()));
        }

        public static SortingOperations getSortingOperationByLabel(String label) {
            return mapLabels.get(label);
        }

        static {
            mapLabels = Arrays.stream(SortingOperations.values()).collect(Collectors.toMap(SortingOperations::getLabel, Function.identity()));
        }
    }

    private class CardEntry
    extends VBox
    implements Disposable {
        private Card3D card3D;
        private Card cardObject;
        private final ImageView cardImage;
        private final Text text;
        private boolean isValid;

        public CardEntry(int id, Card3D card3D) {
            this.card3D = card3D;
            this.cardObject = card3D.getCardIndex().getCardReference();
            this.setPadding(new Insets(5.0));
            this.setAlignment(Pos.CENTER);
            this.setBackground(UIConst.Style.BACKGROUND_BLACK);
            this.setSpacing(2.0);
            this.cardImage = OverlayWindow.createCardImage(card3D.getCardIndex(), false);
            this.setOnMouseEntered(e -> {
                this.cardImage.getOnMouseEntered().handle(e);
                if (!this.isValid || OverlayWindowCardList.this.isLocked || OverlayWindowCardList.this.listPickedCards.contains(card3D)) {
                    return;
                }
                this.setBackground(UIConst.Style.BACKGROUND_HOVER);
            });
            this.setOnMouseExited(e -> {
                if (!this.isValid || OverlayWindowCardList.this.isLocked || OverlayWindowCardList.this.listPickedCards.contains(card3D)) {
                    return;
                }
                this.setBackground(UIConst.Style.BACKGROUND_BLACK);
            });
            if (OverlayWindowCardList.this.maxPicks > 0) {
                this.setOnMouseClicked(e -> {
                    if (!this.isValid || OverlayWindowCardList.this.isLocked) {
                        return;
                    }
                    if (!OverlayWindowCardList.this.listPickedCards.contains(card3D)) {
                        OverlayWindowCardList.this.listPickedCards.add(card3D);
                        this.setBackground(UIConst.Style.BACKGROUND_MID);
                    } else {
                        OverlayWindowCardList.this.listPickedCards.remove(card3D);
                        this.setBackground(UIConst.Style.BACKGROUND_HOVER);
                    }
                    if (!OverlayWindowCardList.this.listChangedPickedStateCards.contains(card3D)) {
                        OverlayWindowCardList.this.listChangedPickedStateCards.add(card3D);
                    } else {
                        OverlayWindowCardList.this.listChangedPickedStateCards.remove(card3D);
                    }
                    OverlayWindowCardList.this.updatePickedCount(OverlayWindowCardList.this.listPickedCards.size());
                });
            }
            this.text = new Text(String.valueOf(id));
            this.text.setFont(Font.font((String)LanguageParser.getString("UI_FONT"), (FontWeight)FontWeight.BOLD, (double)10.0));
            this.text.setFill((Paint)Color.WHITE);
            this.getChildren().addAll((Object[])new Node[]{this.cardImage, this.text});
            GameConst.CardUnderCategory underCategory = card3D.getCardIndex().getUnderType().getUnderCategory();
            if (underCategory != GameConst.CardUnderCategory.NONE) {
                Text textUnderCategory = new Text(underCategory.getLabel());
                textUnderCategory.setFont(this.text.getFont());
                textUnderCategory.setFill(this.text.getFill());
                this.getChildren().add((Object)textUnderCategory);
            }
        }

        public void setId(int id) {
            this.text.setText(String.valueOf(id));
        }

        public void setIsValid(boolean isValid) {
            this.isValid = isValid;
            if (isValid) {
                if (OverlayWindowCardList.this.picker != null) {
                    if (OverlayWindowCardList.this.picker.getPickedList().contains(this.card3D)) {
                        if (!OverlayWindowCardList.this.listPickedCards.contains(this.card3D)) {
                            OverlayWindowCardList.this.listPickedCards.add(this.card3D);
                        }
                        this.setBackground(UIConst.Style.BACKGROUND_MID);
                        OverlayWindowCardList.this.updatePickedCount(OverlayWindowCardList.this.listPickedCards.size());
                    }
                } else if (OverlayWindowCardList.this.listPickedCards.contains(this.card3D)) {
                    this.setBackground(UIConst.Style.BACKGROUND_MID);
                }
                this.cardImage.setOpacity(1.0);
            } else {
                if (OverlayWindowCardList.this.picker == null && OverlayWindowCardList.this.listPickedCards.remove(this.card3D)) {
                    OverlayWindowCardList.this.updatePickedCount(OverlayWindowCardList.this.listPickedCards.size());
                }
                this.cardImage.setOpacity(0.75);
                this.setBackground(UIConst.Style.BACKGROUND_BLACK);
            }
        }

        public Card3D getSourceCard3D() {
            return this.card3D;
        }

        public Card getCardReference() {
            return this.cardObject;
        }

        @Override
        public void dispose() {
            this.cardImage.setImage(null);
            this.cardImage.setOnMouseEntered(null);
            this.setOnMouseEntered(null);
            this.setOnMouseExited(null);
            this.setOnMouseClicked(null);
            this.card3D = null;
            this.cardObject = null;
        }
    }
}

