/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.window;

import java.util.ArrayList;
import java.util.List;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.web.WebView;
import open.batoru.catalog.description.DescriptionParser;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.ConstantAbility;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.parsers.LanguageParser;

public class OverlayWindowChoice
extends OverlayWindow {
    private final List<Button> listButtons = new ArrayList<Button>();
    private ImageView imageCard;

    public OverlayWindowChoice(String title, String description, Ability ability, List<String> listOptions) {
        super(title, description);
    }

    public OverlayWindowChoice(String title, Ability ability, List<String> listOptions) {
        super(title != null ? title : LanguageParser.getString(!(ability instanceof ConstantAbility) ? "UI_GAME_WINDOW_ABILITY_TITLE_ACTIVATE" : "UI_GAME_WINDOW_ABILITY_TITLE_USE"), null);
        HBox container = new HBox();
        container.setAlignment(Pos.CENTER);
        container.setSpacing(10.0);
        this.imageCard = OverlayWindowChoice.createCardImage(ability.getSourceCardIndex());
        WebView descriptionWebView = new WebView();
        descriptionWebView.setContextMenuEnabled(false);
        descriptionWebView.getEngine().setJavaScriptEnabled(false);
        descriptionWebView.setMaxSize(300.0, 80.0);
        descriptionWebView.getEngine().loadContent(DescriptionParser.DEFAULT.parseDescription(!(ability instanceof ConstantAbility) ? ability.getCachedAbilityDescription() : DescriptionParser.getActionReplacementAbilityDescription(ability.getCachedAbilityDescription())));
        container.getChildren().addAll((Object[])new Node[]{this.imageCard, descriptionWebView});
        this.getContentNode().getChildren().add((Object)container);
        if (listOptions == null || listOptions.isEmpty()) {
            Button buttonYes = OverlayWindowChoice.createButton(LanguageParser.getString("UI_GAME_WINDOW_BUTTON_YES"));
            Button buttonNo = OverlayWindowChoice.createButton(LanguageParser.getString("UI_GAME_WINDOW_BUTTON_NO"));
            this.listButtons.add(buttonYes);
            this.listButtons.add(buttonNo);
            this.addWindowButton(buttonYes);
            this.addWindowButton(buttonNo);
        } else {
            for (String option : listOptions) {
                Button button = OverlayWindowChoice.createButton(option);
                this.listButtons.add(button);
                this.addWindowButton(button);
            }
        }
        this.hideConfirmButton();
    }

    public List<Button> getButtonsList() {
        return this.listButtons;
    }

    @Override
    public void forceFakeChoice(List<String> choices) {
        this.listButtons.get(Integer.parseInt(choices.getFirst()) - 1).fire();
    }

    @Override
    public void dispose() {
        super.dispose();
        if (this.imageCard != null) {
            this.imageCard.setOnMouseEntered(null);
        }
    }
}

