/*
 * Decompiled with CFR 0.152.
 */
package open.batoru.game.overlay.window;

import java.lang.runtime.SwitchBootstraps;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.image.Image;
import javafx.scene.image.ImageView;
import javafx.scene.layout.HBox;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.shape.Rectangle;
import open.batoru.ImageCache;
import open.batoru.core.gameplay.pickers.TargetFilter;
import open.batoru.data.CardConst;
import open.batoru.data.ability.Ability;
import open.batoru.data.ability.AbilityCostList;
import open.batoru.data.ability.cost.AbilityCost;
import open.batoru.data.ability.cost.CoinCost;
import open.batoru.data.ability.cost.CollaboLiverCost;
import open.batoru.data.ability.cost.DownCost;
import open.batoru.data.ability.cost.EnerCost;
import open.batoru.game.FieldZoneNumbers;
import open.batoru.game._3d.textures.UtilTexture;
import open.batoru.game.overlay.window.OverlayWindow;
import open.batoru.game.overlay.window.OverlayWindowEnerCost;
import open.batoru.parsers.LanguageParser;
import open.batoru.ui.UIConst;
import open.batoru.ui.UtilDispose;

public class OverlayWindowChoiceCost
extends OverlayWindow {
    private OnCostChosenHandler handler;
    private final List<Integer> cachePayableCostListsId = new ArrayList<Integer>();
    private boolean isLocked;

    public OverlayWindowChoiceCost(String title, List<AbilityCostList> dataCostLists, boolean isMandatory) {
        super(title, LanguageParser.getString("UI_GAME_WINDOW_COST_DESC"));
        this.getContentNode().setSpacing(10.0);
        for (int i = 0; i < dataCostLists.size(); ++i) {
            boolean canBePaidPrivately;
            if (!isMandatory) {
                this.cachePayableCostListsId.add(i);
                this.addCost(dataCostLists.get(i), i, true);
                continue;
            }
            boolean bl = canBePaidPrivately = dataCostLists.get(i).canBePaid() && dataCostLists.get(i).canBePaidPrivately();
            if (canBePaidPrivately) {
                this.cachePayableCostListsId.add(i);
            }
            this.addCost(dataCostLists.get(i), i, canBePaidPrivately);
        }
        if (!isMandatory && !this.cachePayableCostListsId.isEmpty()) {
            this.hideConfirmButton();
        } else {
            this.getConfirmButton().setText(LanguageParser.getString("UI_GAME_WINDOW_BUTTON_SKIP"));
            this.getConfirmButton().setOnAction(e -> {
                this.getConfirmButton().setDisable(true);
                if (this.handler != null) {
                    this.handler.handle(-1);
                }
            });
        }
    }

    public void setOnCostChosen(OnCostChosenHandler handler) {
        this.handler = handler;
    }

    public OnCostChosenHandler getOnCostChosenHandler() {
        return this.handler;
    }

    private void addCost(AbilityCostList costList, int costId, boolean isActive) {
        StackPane container = new StackPane();
        HBox content = new HBox();
        content.setAlignment(Pos.CENTER);
        content.setSpacing(10.0);
        content.setMinHeight(60.9);
        if (isActive) {
            content.setOnMouseEntered(e -> {
                if (!this.isLocked) {
                    content.setBackground(UIConst.Style.BACKGROUND_HOVER);
                }
            });
            content.setOnMouseExited(e -> {
                if (!this.isLocked) {
                    content.setBackground(UIConst.Style.BACKGROUND_TRANSPARENT);
                }
            });
            content.setOnMouseClicked(e -> {
                if (!this.isLocked && this.handler != null) {
                    this.handler.handle(costId);
                }
            });
        } else {
            content.setOpacity(0.5);
        }
        HBox contentSources = new HBox();
        contentSources.setSpacing(-41.580000000000005);
        contentSources.setPadding(new Insets(0.0, 0.0, 0.0, 5.0));
        contentSources.setMaxWidth(63.0);
        StackPane.setAlignment((Node)contentSources, (Pos)Pos.CENTER_LEFT);
        container.getChildren().addAll((Object[])new Node[]{content, contentSources});
        ArrayList<ImageView> sourceImages = new ArrayList<ImageView>();
        block6: for (AbilityCost cost : costList.getDataArray()) {
            AbilityCost abilityCost;
            Ability sourceAbility = cost.getSourceAbility();
            if (sourceAbility != null) {
                ImageView imageSourceCard = OverlayWindowChoiceCost.createCardImage(Ability.getRootSourceAttachAbility(sourceAbility).getSourceCardIndex(), false);
                contentSources.getChildren().add((Object)imageSourceCard);
                sourceImages.add(imageSourceCard);
            }
            Objects.requireNonNull(cost);
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{EnerCost.class, CollaboLiverCost.class, CoinCost.class, DownCost.class}, (Object)abilityCost, n)) {
                case 0: {
                    EnerCost enerCost = (EnerCost)abilityCost;
                    for (char c : enerCost.getCostString().getValue().toCharArray()) {
                        content.getChildren().add((Object)new OverlayWindowEnerCost.EnerIcon(CardConst.CardColor.getColorByShortLabel(c)));
                    }
                    continue block6;
                }
                case 1: {
                    CollaboLiverCost collaboLiverCost = (CollaboLiverCost)abilityCost;
                    for (int i = 0; i < collaboLiverCost.getCostMinCount(); ++i) {
                        content.getChildren().add((Object)new ImageView(ImageCache.INSTANCE.getImage(ImageCache.getGFXTexturePath("vtuber/cost_icon"))));
                    }
                    continue block6;
                }
                case 2: {
                    CoinCost coinCost = (CoinCost)abilityCost;
                    if (coinCost.getCostMinCount() > 0) {
                        for (int i = 0; i < coinCost.getCostMinCount(); ++i) {
                            content.getChildren().add((Object)new ImageView(ImageCache.INSTANCE.getImageIcon("coin")));
                        }
                        continue block6;
                    }
                    content.getChildren().add((Object)new ImageView(ImageCache.INSTANCE.getImageIcon("coin0")));
                    break;
                }
                case 3: {
                    DownCost downCost = (DownCost)abilityCost;
                    for (int i = 0; i < downCost.getCostMaxCount(); ++i) {
                        content.getChildren().add((Object)new ImageView(ImageCache.INSTANCE.getImageIcon("down")));
                    }
                    continue block6;
                }
                default: {
                    boolean hasZeroCost = cost.getCostMaxCount() == 0;
                    int maxCount = !hasZeroCost ? cost.getCostMaxCount() : 1;
                    for (int i = 0; i < maxCount; ++i) {
                        TargetFilter.TargetHint hintTargetType;
                        StackPane containerImage = new StackPane();
                        containerImage.setMinSize(44.099999999999994, 60.9);
                        containerImage.setMaxSize(containerImage.getMinWidth(), containerImage.getMinHeight());
                        ImageView imageCard = new ImageView(ImageCache.INSTANCE.getMainCardBackImage());
                        imageCard.setFitWidth(44.099999999999994);
                        imageCard.setFitHeight(60.9);
                        Rectangle clip = new Rectangle(44.099999999999994, 60.9);
                        clip.setArcWidth(6.3);
                        clip.setArcHeight(6.3);
                        imageCard.setClip((Node)clip);
                        containerImage.getChildren().add((Object)imageCard);
                        TargetFilter.TargetHint targetHint = hintTargetType = cost.getFilter() == null || cost.getFilter().getHintTargetType() == TargetFilter.TargetHint.GENERIC ? cost.getDefaultTargetHintType() : cost.getFilter().getHintTargetType();
                        if (hintTargetType != TargetFilter.TargetHint.GENERIC) {
                            ImageView imageHint = new ImageView(ImageCache.INSTANCE.getImage(ImageCache.getBorderIconTexturePath(hintTargetType)));
                            imageHint.setScaleX(0.75);
                            imageHint.setScaleY(0.75);
                            containerImage.getChildren().add((Object)imageHint);
                            if (hasZeroCost) {
                                ImageView imageZero = new ImageView((Image)UtilTexture.colorize(ImageCache.INSTANCE.getImage(ImageCache.getDigitsTexturePath(0, FieldZoneNumbers.NumberTexture.OUTLINE)), Color.LIMEGREEN));
                                imageZero.setScaleX(0.4);
                                imageZero.setScaleY(0.4);
                                containerImage.getChildren().add((Object)imageZero);
                            }
                        }
                        content.getChildren().add((Object)containerImage);
                    }
                    continue block6;
                }
            }
        }
        UtilDispose.TEMP.setOnDisposed((Node)container, () -> {
            content.setOnMouseEntered(null);
            content.setOnMouseExited(null);
            content.setOnMouseClicked(null);
            for (ImageView image : sourceImages) {
                image.setOnMouseEntered(null);
            }
        });
        this.getContentNode().getChildren().add((Object)container);
    }

    public void setLock(boolean set) {
        this.isLocked = set;
    }

    public List<Integer> getDataPayableCostLists() {
        return this.cachePayableCostListsId;
    }

    @Override
    public void forceFakeChoice(List<String> choices) {
        if (!choices.getFirst().isEmpty()) {
            this.handler.handle(Integer.parseInt(choices.getFirst()));
        } else {
            this.handler.handle(-1);
        }
    }

    @Override
    public void dispose() {
        super.dispose();
        UtilDispose.TEMP.attachChildDisposeListener((Node)this.getContentNode());
        this.getContentNode().getChildren().clear();
        UtilDispose.TEMP.detachChildDisposeListener((Node)this.getContentNode());
        this.handler = null;
    }

    @FunctionalInterface
    public static interface OnCostChosenHandler {
        public void handle(int var1);
    }
}

